//
//  UITableView+RefreshControl.m
//  QGScrollLabel
//
//  Created by silicn on 2019/5/9.
//  Copyright © 2019 Silicn. All rights reserved.
//

#import "UITableView+RefreshControl.h"
#import "objc/message.h"
#import "MJRefresh.h" 
#import "QGRefreshNomalHeader.h"
#import "SwizzleMethod.h"
#import "QGAppMacro.h"
#import "UIFont+QGFont.h"
#import "UIColor+QGColor.h"
static const char *loadDataPageNumKey = "LoadDataPageNumKey";
static const char *loadDataPageCountKey = "LoadDataPageCountKey";
static const char *refreshLoadDataBlockKey = "refreshLoadDataBlockKey";

@interface UITableView ()

@property (nonatomic, copy)RefreshBlock refreshBlock;


@end

@implementation UITableView (RefreshControl)

- (void)setPageNum:(NSInteger)pageNum
{
    objc_setAssociatedObject(self, loadDataPageNumKey, @(pageNum), OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSInteger)pageNum{
    return [objc_getAssociatedObject(self, loadDataPageNumKey) integerValue];
}

- (void)setPageCount:(NSInteger)pageCount
{
    objc_setAssociatedObject(self,loadDataPageCountKey , @(pageCount), OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (NSInteger)pageCount{
    return [objc_getAssociatedObject(self, loadDataPageCountKey) integerValue];
}

- (void)setRefreshBlock:(RefreshBlock)refreshBlock
{
    objc_setAssociatedObject(self, refreshLoadDataBlockKey, refreshBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (RefreshBlock)refreshBlock
{
    return objc_getAssociatedObject(self, refreshLoadDataBlockKey);
}

#pragma mark — 仅有下拉刷新的方法


- (QGRefreshNomalHeader *)addHeaderRefreshOnlyWithHandle:(RefreshBlock)refreshingBlock
{
    if (self.mj_header == nil) {
        QGRefreshNomalHeader *header = [QGRefreshNomalHeader headerWithRefreshingBlock:^{
            if (refreshingBlock) {refreshingBlock(YES);} 
        }];
        [header setTitle:@"下拉刷新" forState:MJRefreshStateIdle];
        [header setTitle:@"努力刷新中..." forState:MJRefreshStateRefreshing];
        [header setTitle:@"松开刷新" forState:MJRefreshStatePulling];
        [header setTitle:@"松开刷新..." forState:MJRefreshStateWillRefresh];
        self.mj_header = header;
    }
    return (QGRefreshNomalHeader *)self.mj_header;
}

- (void)beginHeaderRefresh
{
    if (self.mj_footer.state == MJRefreshStateRefreshing) {
        [self.mj_footer endRefreshing];
    }
    [self.mj_header beginRefreshing];
    
}

- (void)endHeaderRefreshWithBlock:(EndRefreshBlock)endBlock;
{
    if (self.mj_header) {
        [self.mj_header endRefreshingWithCompletionBlock:endBlock];
    }
}


#pragma mark — 仅有上拉加载的方法

- (void)addFooterRefreshOnlyWithHandle:(RefreshBlock)refreshingBlock
{
    self.refreshBlock = refreshingBlock;
}

- (void)initFooter
{
    if (self.mj_footer == nil) {
        __weak typeof(self) weakSelf = self;
        MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
            if (weakSelf.refreshBlock) {weakSelf.refreshBlock(NO);}
        }];
        self.mj_footer = footer;
        [footer setTitle:@"上拉加载"forState:MJRefreshStateIdle];
        [footer setTitle:@"-没有更多数据了-"  forState:MJRefreshStateNoMoreData];
        footer.stateLabel.textColor = [UIColor textColor9999];
        footer.stateLabel.font = [UIFont qg_lightFontOfSize:14];
        [footer setTitle:@"正在加载..." forState:MJRefreshStateRefreshing];
        [footer setTitle:@"松开拉取" forState:MJRefreshStateWillRefresh];
        [footer setTitle:@"松开拉取" forState:MJRefreshStatePulling];
        
    }
}


- (void)beginFooterLoadData
{
    if (self.mj_footer) {
        [self.mj_footer beginRefreshing];
    }
}

- (void)endFooterLoadDataWithBlock:(EndLoadDataBlock)endBlock
{
    if (self.mj_footer) {
        if (endBlock) {
            [self.mj_footer endRefreshing];
            int count = endBlock();
            if (self.pageCount > 0 && count >= self.pageCount) {
                self.pageNum += 1;
            }else{
                [self.mj_footer endRefreshingWithNoMoreData];
            }
        }
    }
    //加入数据列表比较少或者没有数据，Footer隐藏
    if (self.contentSize.height < self.frame.size.height) {
        [self removeFooterLoadData];
    }else{
        if (self.mj_footer == nil){
            [self initFooter];
        }
    }
}

- (void)removeFooterLoadData
{
    if (self.mj_footer) {
         [self.mj_footer removeFromSuperview];
         self.mj_footer = nil;
    }
    
}

- (QGRefreshNomalHeader *)addRefreshWithHandle:(RefreshBlock)refreshingBlock
{
    if (self.mj_header == nil) {
        @weakify(self);
        QGRefreshNomalHeader *header = [QGRefreshNomalHeader headerWithRefreshingBlock:^{
            @strongify(self);
            //每次下拉刷新触发的时候，清理掉旧的上拉加载
            [self removeFooterLoadData];
            if (refreshingBlock) {refreshingBlock(YES);} 
        }];
        [header setTitle:@"下拉刷新" forState:MJRefreshStateIdle];
        [header setTitle:@"努力刷新中..." forState:MJRefreshStateRefreshing];
        [header setTitle:@"松开刷新" forState:MJRefreshStatePulling];
        [header setTitle:@"松开刷新..." forState:MJRefreshStateWillRefresh];
        self.mj_header = header;
    }
    
    if (self.mj_footer == nil) {
        self.refreshBlock = refreshingBlock;
    }
    return (QGRefreshNomalHeader *)self.mj_header;
}

- (void)beginRefresh
{
    ///每次下拉刷新触发的时候，清理掉旧的上拉加载
    [self removeFooterLoadData];
    [self beginHeaderRefresh];
}


/// 结束下拉刷新或者上拉加载更多 （用于明确知道是否有下一页）
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param hasNext 是否有下一页
- (void)endRefreshWithBusinessSuccess:(BOOL)isBusinessSuccess hasNext:(BOOL)hasNext
{
    [self endRefreshWithRefreshBlock:nil businessSuccess:isBusinessSuccess hasNext:hasNext];
}

- (void)endRefreshWithRefreshBlock:(nullable EndRefreshBlock)refreshBlock businessSuccess:(BOOL)isBusinessSuccess hasNext:(BOOL)hasNext
{
    //处理上下拉逻辑
    if (self.mj_header.state == MJRefreshStateRefreshing) {
       [self.mj_header endRefreshingWithCompletionBlock:refreshBlock];
    }

    if (self.mj_footer.state == MJRefreshStateRefreshing) {
       [self.mj_footer endRefreshingWithCompletionBlock:refreshBlock];
    }

    //如果业务逻辑处理失败，或者请求失败 后续不做处理
    if (!isBusinessSuccess) {
       return;
    }

    //检测是否有上拉刷新，没有则添加
    if (self.mj_footer == nil){
       [self initFooter];
    }
       
    //如果有更多数据，页码自增，否则展示没有更多数据了
    if (hasNext) {
        self.pageNum += 1;
    }
    else
    {
        [self.mj_footer endRefreshingWithNoMoreData];
        /// 不够一屏不显示
        if (self.frame.size.height >= self.contentSize.height) {
            [self.mj_footer removeFromSuperview];
            self.mj_footer = nil;
            
        }
    }
}


/// 结束下拉刷新或者上拉加载更多
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param count 获得的页码，请求失败时为0
- (void)endRefreshWithBusinessSuccess:(BOOL)isBusinessSuccess count:(NSUInteger)count
{
    [self endRefreshWithRefreshBlock:nil businessSuccess:isBusinessSuccess count:count];
}

- (void)endRefreshWithRefreshBlock:(nullable EndRefreshBlock)refreshBlock businessSuccess:(BOOL)isBusinessSuccess count:(NSUInteger)count
{
    //处理上下拉逻辑
    if (self.mj_header.state == MJRefreshStateRefreshing) {
        [self.mj_header endRefreshingWithCompletionBlock:refreshBlock];
    }
    
    if (self.mj_footer.state == MJRefreshStateRefreshing) {
        [self.mj_footer endRefreshingWithCompletionBlock:refreshBlock];
    }
    
    //如果业务逻辑处理失败，或者请求失败 后续不做处理
    if (!isBusinessSuccess) {
        return;
    }
    
    //检测是否有上拉刷新，没有则添加
    if (self.mj_footer == nil){
        [self initFooter];
    }
    
    //如果数据满足要求页码自增，否则没有更多数据
    if (self.pageCount  > 0 && count >= self.pageCount) {
        self.pageNum += 1;
    }else{
        [self.mj_footer endRefreshingWithNoMoreData];
        /// 不够一屏不显示
        if (self.frame.size.height >= self.contentSize.height) {
            [self.mj_footer removeFromSuperview];
            self.mj_footer = nil;
        }
        
    }
    
}




+ (void)load
{
    swizzleMethod([self class], @selector(setDelegate:), @selector(aop_setDelegate:));
}

- (void)aop_setDelegate:(id<UITableViewDelegate>)delegate
{
    [self aop_setDelegate:delegate];
    //兼容iOS11
    if (iOS11) {
        self.estimatedRowHeight           = 0;
        self.estimatedSectionHeaderHeight = 0;
        self.estimatedSectionFooterHeight = 0;
    }
    
#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000)
    if (@available(iOS 11.0, *)) {
        if ([self respondsToSelector:@selector(contentInsetAdjustmentBehavior)]) {
            self.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
        }
    }
#endif
}


@end
