//
//  UITableView+RefreshControl.h
//  QGScrollLabel
//
//  Created by silicn on 2019/5/9.
//  Copyright © 2019 Silicn. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "QGRefreshNomalHeader.h"

NS_ASSUME_NONNULL_BEGIN

typedef void (^RefreshBlock)(BOOL isHeaderRefresh);

typedef void (^EndRefreshBlock)(void);

typedef int (^EndLoadDataBlock)(void);

@interface UITableView (RefreshControl)
/// 下次DataList的PageNum
@property (nonatomic, assign)NSInteger pageNum;
/// 每页的获取的DataList数量
@property (nonatomic, assign) NSInteger pageCount;


#pragma mark - 仅且只有下拉刷新

/**
 适合类型：初始化下拉刷新，并且仅有下拉刷新 返回的isHeaderRefresh:YES
 
 @param refreshingBlock 下拉刷新时将要执行的action 
 @discuss isHeaderRefresh always is YES
 */
- (QGRefreshNomalHeader *)addHeaderRefreshOnlyWithHandle:(RefreshBlock)refreshingBlock;

/**
 开始下拉刷新
 */
- (void)beginHeaderRefresh;

/**
 结束下拉刷新

 @param endBlock 结束下拉刷新之后执行endBlock
 */
- (void)endHeaderRefreshWithBlock:(nullable EndRefreshBlock)endBlock;


#pragma mark - 仅且只有上拉刷新
///**
// 适合类型：初始化上拉加载更多，并且仅有上拉加载更多
//
// @param refreshingBlock 上拉加载更多将要执行的action
// @discuss isRefresh always is YES
// */
//- (void)addFooterRefreshOnlyWithHandle:(RefreshBlock)refreshingBlock;
//
///**
// 结束上拉加载更多Data
//
// @param endBlock 结束加载数据之后执行endBlock
// */
//- (void)endFooterLoadDataWithBlock:(EndLoadDataBlock)endBlock;

/**
 删除下拉加载更多Data
 */
- (void)removeFooterLoadData;


#pragma mark - 同时具有下拉加载(isHeaderRefresh:YES)和上拉加载更多(isHeaderRefresh:NO)
/**
 适合类型：同时具有下拉加载(isHeaderRefresh:YES)和上拉加载更多(isHeaderRefresh:NO)

 @param refreshingBlock 下拉刷新或者上拉加载更多将要执行的action
 @discuss isHeaderRefresh 下拉刷新：YES  上拉加载更多：NO
 */
- (QGRefreshNomalHeader *)addRefreshWithHandle:(RefreshBlock)refreshingBlock;

/**
 开始下拉刷新或者上拉加载更多
 */
- (void)beginRefresh;



/// 结束下拉刷新或者上拉加载更多 （用于明确知道是否有下一页）
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param hasNext 是否有下一页
- (void)endRefreshWithBusinessSuccess:(BOOL)isBusinessSuccess hasNext:(BOOL)hasNext;



/// 结束下拉刷新或者上拉加载更多（内部通过count、pageCount对比是否还有下一页）
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param count 获得的页码，请求失败时为0 内部自动对比是否有下一页
- (void)endRefreshWithBusinessSuccess:(BOOL)isBusinessSuccess count:(NSUInteger)count;

/// 结束下拉刷新或者上拉加载更多
/// @param refreshBlock 结束下拉刷新之后执行refreshBlock
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param count 获得的页码，请求失败时为0  内部自动对比是否有下一页
- (void)endRefreshWithRefreshBlock:(nullable EndRefreshBlock)refreshBlock businessSuccess:(BOOL)isBusinessSuccess count:(NSUInteger)count;



@end

NS_ASSUME_NONNULL_END
