//
//  UIFont+QGFont.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "UIFont+QGFont.h"

@implementation UIFont (QGFont)

/**
 对应设计稿 light 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_lightFontOfSize:(CGFloat)fontSize
{
    UIFont *font = [UIFont fontWithName:@"PingFangSC-Light" size:fontSize];
    if (!font) {
        font = [UIFont fontWithName:@"Helvetica-Light" size:fontSize];
    }
    return font;
}


/**
 对应设计稿 medium/Bold 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_mediumFontOfSize:(CGFloat)fontSize
{
    UIFont *font = [UIFont fontWithName:@"PingFangSC-Medium" size:fontSize];
    if (!font) {
        font = [UIFont fontWithName:@"Helvetica-Bold" size:fontSize];
    }
    return font;
}


/**
 对应设计稿 Semibold 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_semiboldFontOfSize:(CGFloat)fontSize
{
    UIFont *font = [UIFont fontWithName:@"PingFangSC-Semibold" size:fontSize];
    if (!font) {
        font = [UIFont fontWithName:@"Helvetica-Bold" size:fontSize];
    }
    return font;
}


/**
 对应设计稿 regular 样式字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_regularFontOfSize:(CGFloat)fontSize
{
    
    UIFont *font = [UIFont fontWithName:@"PingFangSC-Regular" size:fontSize];
    if (!font) {
        font = [UIFont fontWithName:@"Helvetica" size:fontSize];
    }
    return font;
}


/**
 数字专用字体
 @param fontSize 字体大小
 @return 字体实例
 */
+ (UIFont *)qg_numberFontOfSize:(CGFloat)fontSize
{
    
    UIFont *font = [UIFont fontWithName:@"DINAlternate-bold" size:fontSize];
    if (!font) {
        font = [UIFont fontWithName:@"Helvetica-Bold" size:fontSize];
    }
    return font;
}

@end
