//
//  UIColor+QGColor.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface UIColor (QGColor)

/**
 导航栏默认字体颜色
 */
+ (UIColor *)navigationTitleColor;

/**
 导航栏默认背景色
 */
+ (UIColor *)navigationBarColor;

/**
 导航栏的tintColor  左右侧按钮/文案颜色
 */
+(UIColor*)navigationTintColor;

/**
 产品色-用于大面积使用（如顶部背景色、按钮颜色）
 */
+ (NSArray *)gradientColors;

/// 推广会员相关的渐变色
+ (NSArray *)gradientColorsE9B176ToF2CD8B;

/// 推广会员相关的渐变色
+ (NSArray *)gradientColorsE9B176ToF2CD8B:(CGFloat)alpha;

/**
 产品色-用于大面积使用（如顶部背景色、按钮颜色）有透明度的
 
 @param alpha 透明度
 */
+ (NSArray *)gradientColorsAlpha:(CGFloat)alpha;

/**
 阳阳定的新的主体色
 */
+ (UIColor *)yyMainThemeColor;

/**
 产品色-用于特别需要强调的文字或者按钮和icon
 （如tab栏文字，弹窗按钮文字等）
 */
+ (UIColor *)mainThemeColor;


/**
 用于toast、消息提示背景色
 */
+ (UIColor *)toastBackgroundColor;

/**
 用于toast、消息提示等文字颜色
 */
+ (UIColor *)toastTextColor;

/**
 小面积使用，用于需要特别强调的文字
 （如逾期提示等）
 */
+ (UIColor *)textColorF41C1C;

/**
 主要用于背景蒙层，透明度为40%
 （如所有弹窗和选择模块等）
 */
+ (UIColor *)backgroundColor0000;

/**
 主要用于主文案以及列表内容等
 （如首页借款数值以及期限数值等）
 */
+ (UIColor *)textColor3333;

/**
 主要用于副文案或者不用强调的标题
 （如列表的内容文案等）
 */
+ (UIColor *)textColor6666;

///ECECEC
+ (UIColor *)imageBackgroundColorF0F0F0;

/**
 主要用于内容很多的附属文案
 （如列表的输入提示文案等）
 */
+ (UIColor *)textColor9999;

/**
 主要用于列表分割线的颜色
 */
+ (UIColor *)lineSeparatorColorDCDC;

/**
 主要用于模块分割线的颜色
 */
+ (UIColor *)moduleSeparatorColorF7F7;

/**
 根据HexString创建颜色
 */
+ (UIColor *)colorWithHexString:(NSString *)hexString;

/**
 根据HexString创建颜色
 */
+ (UIColor *)colorWithHexString:(NSString *)hexString alpha:(CGFloat)alpha;

/**
 *  生活缴费-背景颜色
 */
+(UIColor*)lifePayBackGroudColor;

/**
 *  输入框边框颜色
 */
+(UIColor*)mainBorderColor;

/// 阴影色
+ (UIColor *)shadowColor;
@end

NS_ASSUME_NONNULL_END
