//
//  UICollectionView+RefreshControl.h
//  VirtualPayment
//
//  Created by silicn on 2020/3/15.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "QGRefreshNomalHeader.h"


NS_ASSUME_NONNULL_BEGIN

typedef void (^RefreshBlock)(BOOL isHeaderRefresh);


@interface UICollectionView (RefreshControl)

/// 下次DataList的PageNum
@property (nonatomic, assign)NSInteger pageNum;
/// 每页的获取的DataList数量
@property (nonatomic, assign) NSInteger pageCount;


/// 添加下拉刷新
/// @param refreshingBlock 刷新回调
- (QGRefreshNomalHeader *)addRefreshWithHandle:(RefreshBlock)refreshingBlock;

/// 结束下拉刷新或者上拉加载更多 （用于明确知道是否有下一页）
/// @param isBusinessSuccess 请求成功，并且业务状态为0000时为YES 其余都为NO
/// @param hasNext 是否有下一页
- (void)endRefreshWithBusinessSuccess:(BOOL)isBusinessSuccess hasNext:(BOOL)hasNext;

@end

NS_ASSUME_NONNULL_END
