//
//  UIButton+QGAdd.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/8.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "UIButton+QGAdd.h"
#import <objc/runtime.h>
#import "SwizzleMethod.h"


@interface UIButton (ClickBolck)

/**
 button按钮点击触发事件  内部使用
 */
@property (nonatomic, copy) ButtonActionBlock actionBlock;

@end


@implementation UIButton (ClickBolck)

#pragma mark - Setter
- (void)setActionBlock:(ButtonActionBlock)actionBlock
{
    objc_setAssociatedObject(self, @selector(actionBlock), actionBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

#pragma mark - Getter
- (ButtonActionBlock)actionBlock
{
    return objc_getAssociatedObject(self, @selector(actionBlock));
}

@end






@implementation UIButton (QGAdd)


+ (void)initialize
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        Class class = [self class];
        swizzleMethod(class, @selector(setHighlighted:), @selector(aop_setHighlighted:));
    });
}


/**
 *  点击触发block
 */
- (void)touchUpInsideBlock:(ButtonActionBlock)actionBlock
{
    [self touchEventBlock:actionBlock forControlEvents:UIControlEventTouchUpInside];
}

/**
 *  点击触发block
 */
- (void)touchEventBlock:(ButtonActionBlock)actionBlock forControlEvents:(UIControlEvents)controlEvents
{
    self.actionBlock = actionBlock;
    [self addTarget:self action:@selector(touchUpInside:) forControlEvents:controlEvents];
}

- (void)touchUpInside:(UIButton *)button
{
    if (self.actionBlock) {
        self.actionBlock(button);
    }
}

//点击的时候透明度为70%
- (void)aop_setHighlighted:(BOOL)highlighted
{
    self.alpha = highlighted ? .7 :1;
    [self aop_setHighlighted:highlighted];
}


/**
 设置按钮是否可点击，不可点击时自动设置按钮的透明度和状态
 
 @param isEnabled 是否可点击
 */
- (void)setButtonIsClickEnabled:(BOOL)isEnabled
{
    self.userInteractionEnabled = isEnabled;
    self.alpha = isEnabled ? 1 : 0.5;
}


@end
