//
//  UIButton+QGAdd.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/8.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^ButtonActionBlock)(UIButton * button);

@interface UIButton (QGAdd)

/**
 *  点击触发block
 */
- (void)touchUpInsideBlock:(ButtonActionBlock)actionBlock;

/**
 按钮时间触发回调

 @param actionBlock 回调
 @param controlEvents 按钮事件
 */
- (void)touchEventBlock:(ButtonActionBlock)actionBlock forControlEvents:(UIControlEvents)controlEvents;


/**
 设置按钮是否可点击，不可点击时自动设置按钮的透明度和状态
 
 @param isEnabled 是否可点击
 */
- (void)setButtonIsClickEnabled:(BOOL)isEnabled;
@end

NS_ASSUME_NONNULL_END
