//
//  UIViewController+CommonConfig.m
//  LoanRecommend
//
//  Created by 张博 on 2018/8/15.
//  Copyright © 2018年 bo.zhang. All rights reserved.
//

#import "UIViewController+CommonConfig.h"
#import "QGPasswordLoginViewController.h"

#import "UIColor+QGColor.h"
#import "Masonry.h"
//#import "BadNetworkView.h"
#import "QGDefaultView.h"
#import "QGBaseWebViewController.h"
#import "NSString+CreditWallet.h"
#import "QGApplicationOpenURL.h"

@implementation UIViewController (CommonConfig)

/**
 *  自定义返回按钮
 */
-(void)custemLeftDefaultBarButtonItem
{
    [self custemLeftDefaultBarButtonItemWithTouchAction:nil];
}

/**
 *  自定义返回按钮(白色) 默认执行pop/dismsss
 */
-(void)custemLeftWhiteBarButtonItem
{
    [self custemLeftWhiteBarButtonItemWithTouchAction:nil];
}

/**
 自定义返回按钮 白色
 如果实现了点击的Block就需要自己调用返回函数
 @param actionBlock 点击事件
 */
-(void)custemLeftWhiteBarButtonItemWithTouchAction:(ButtonActionBlock)actionBlock
{
    [self customLeftBarButtonItemWithImgName:@"vc_goback_white" action:actionBlock];
}

/**
 自定义返回按钮 黑色
 如果实现了点击的Block就需要自己调用返回函数
 @param actionBlock 点击事件
 */
-(void)custemLeftDefaultBarButtonItemWithTouchAction:(ButtonActionBlock)actionBlock
{
    [self customLeftBarButtonItemWithImgName:@"vc_goback" action:actionBlock];
}

/**
 自定义左侧按钮
 
 @param imgName 图片名称
 @param actionBlock 点击事件
 @return 按钮实例类
 */
- (UIButton *)customLeftBarButtonItemWithImgName:(NSString *)imgName action:(ButtonActionBlock)actionBlock
{
    UIButton* leftBtn= [UIButton buttonWithType:UIButtonTypeCustom];
    UIImage * iconImage = [UIImage imageNamed:imgName];
    [leftBtn setImage:iconImage forState:UIControlStateNormal];
    //如果外面接管了自定义事件，则需要自己调用返回函数
    if (actionBlock) {
        [leftBtn touchUpInsideBlock:^(UIButton * _Nonnull button) {
            actionBlock(button);
        }];
    }
    else
    {
        [leftBtn addTarget:self action:@selector(pop) forControlEvents:UIControlEventTouchUpInside];
    }
    
    leftBtn.frame = CGRectMake(0, 5, 30, 40);
    UIBarButtonItem* leftItem = [[UIBarButtonItem alloc]initWithCustomView:leftBtn];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 11.0) {
        //如果是iOS 11以上版本 修复右滑时可能引起按钮消失的问题
        if ([leftItem.customView isKindOfClass:[UIButton class]]) {
            UIButton *leftButton = (UIButton *)leftItem.customView;
            //图片向左偏移5个像素
            leftButton.imageEdgeInsets = UIEdgeInsetsMake(0, -7.0, 0, 0);
        }
        self.navigationItem.leftBarButtonItem = leftItem;
    }else{
        UIBarButtonItem *negativeSpacer = [[UIBarButtonItem alloc]
                                           initWithBarButtonSystemItem:UIBarButtonSystemItemFixedSpace
                                           target:nil action:nil];
        negativeSpacer.width = -7;//偏移距离  -向左偏移, +向右偏移
        self.navigationItem.leftBarButtonItems = @[negativeSpacer,leftItem];
    }
    return leftBtn;
}


/**
 自定义右侧navItem Button
 ❗️图片和标题二选一，图片优先级高
 @param title 标题
 @param imageName 图片
 @param actionBlock 点击回调
 @return 按钮实力类
 */
-(UIButton *)custemRightBarButtonItemWithTitle:(NSString *)title imageName:(NSString *)imageName action:(ButtonActionBlock)actionBlock
{
    UIButton* rightBarButton= [UIButton buttonWithType:UIButtonTypeCustom];
    CGSize rightButtonSize = CGSizeZero;
    //图片和title互斥
    if (imageName) {
        rightButtonSize = CGSizeMake(40, 40);
        UIImage * image = [UIImage imageNamed:imageName];
        [rightBarButton setImage:image forState:UIControlStateNormal];
        [rightBarButton setImageEdgeInsets:UIEdgeInsetsMake(0, (40 - image.size.width)/2, 0, 0)];
    }
    else if (title.length > 0)
    {
        UIFont * font =[UIFont qg_regularFontOfSize:14];
        CGFloat width = [NSString getWidthWithContent:title height:24 UIFont:font];
        width = width > 54 ? width : 54;
        [rightBarButton setTitle:title forState:UIControlStateNormal];
        rightButtonSize = CGSizeMake(width, 24);
        rightBarButton.titleLabel.font = font;
        rightBarButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
        [rightBarButton setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
    }
    [rightBarButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
        actionBlock(button);
    }];
    
    rightBarButton.frame = CGRectMake(0, 0, rightButtonSize.width, rightButtonSize.height);
    UIBarButtonItem* rightBtnItem = [[UIBarButtonItem alloc]initWithCustomView:rightBarButton];
    self.navigationItem.rightBarButtonItem = rightBtnItem;
    return rightBarButton;
}


/**
 *  从NIB中加载cell 如果有则出列一个cell
 */
-(UITableViewCell *)getCellFromNibName:(NSString *)nibName dequeueTableView:(UITableView *)tableView
{
    static NSString * identifier;
    identifier = nibName;
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        cell = [[NSBundle mainBundle] loadNibNamed:nibName owner:nil options:nil][0];
    }
    return cell;
}


/**
 兼容旧代码
 */
-(UITableViewCell *)getCellFromNibName:(NSString *)nibName objectAtIndex:(NSUInteger)index dequeueTableView:(UITableView *)tableView
{
    static NSString * identifier;
    identifier = nibName;
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        cell = [[NSBundle mainBundle] loadNibNamed:nibName owner:nil options:nil][index];
    }
    return cell;
}

/**
 *  根据类名出列Cell
 */
-(UITableViewCell *)getCellFromClassName:(NSString *)className dequeueTableView:(UITableView *)tableView
{
    static NSString * identifier;
    identifier = className;
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        Class class = NSClassFromString(className);
        cell = [[class alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}


/**
 调用起来登录页面
 */
- (void)showLoginViewController
{
    [self showLoginViewControllerCompletion:nil];
}


/// 显示登录控制器
/// @param successBlock 成功回调
- (void)showLoginViewControllerCompletion:(void(^)())successBlock {
    [self showLoginViewControllerCompletion:successBlock cancleBlock:nil];
}


/// 显示登录控制器
/// @param successBlock 成功回调
/// @param cancleBlock 取消回调
- (void)showLoginViewControllerCompletion:(void(^)())successBlock cancleBlock:(dispatch_block_t)cancleBlock
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGRegisterViewController) isPush:NO parameters:nil handlerBlock:^(NSString *tag, NSDictionary *parameters) {
        //登录成功回调
        if ([tag isEqualToString:LoginTag_QGMainLoginViewController_LoginSuccess]) {
            if (successBlock) {
                successBlock();
            }
        }
        //登录取消回调
        else if ([tag isEqualToString:LoginTag_QGMainLoginViewController_LoginCancle])
        {
            if (cancleBlock) {
                cancleBlock();
            }
        }
    }];
    
}



//LoginTag_QGMainLoginViewController_LoginCancle



#pragma mark - private

- (void)pop
{
    if (self.navigationController.viewControllers.count > 1) {
        [self.navigationController popViewControllerAnimated:YES];
    }
    else
    {
        [self dismissViewControllerAnimated:YES completion:nil];
    }
}



/**
 展示出错误页面重新加载

 @param reloadBlock 重新加载回调
 */
- (QGDefaultView *)showErrorPageReloadBlock:(dispatch_block_t)reloadBlock
{
    QGDefaultView * noInfoView = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
        if (reloadBlock) {
            reloadBlock();
        }
    }];
    noInfoView.viewType = QGDefaultViewTypeBadNetwork;
    return noInfoView;
}


/**
 展示没有信息页面

 @param message 提示文案
 @param imageName 提示图片
 */
- (QGDefaultView *)showNoInfoViewWithMessage:(NSString *)message imageName:(NSString *)imageName buttonTitle:(NSString *)buttonTitle reloadBlock:(dispatch_block_t)reloadBlock
{
    QGDefaultView * noInfoView = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
        if (reloadBlock) {
            reloadBlock();
        }
    }];
    [noInfoView setIconImageWithImageName:imageName messageTitle:message buttonTitle:buttonTitle];
    return noInfoView;
}

/**
 跳转到指定网页

 @param url 网页地址
 */
- (void)navigationToWeb:(NSString *)url{
    if ([NSString isEmpty:url]) {
        [QGHUDManager showHud:@"当前跳转已失效"];
        return;
    }
    QGBaseWebViewController * webVC = [[QGBaseWebViewController alloc]init];
    webVC.urlString = url;
    [self.navigationController pushViewController:webVC animated:YES];
}


/// 跳转到协议链接 http || xyqb
- (void)navigationToAllSupportUrl:(NSString *)navUrl{
    if (![NSString isEmpty:navUrl]) {
        [QGApplicationOpenURL handleAllSupportUrl:navUrl];
    }
    else
    {
        [QGHUDManager showHud:@"当前跳转已失效"];
    }
}



//-(void)jumpViewControllerAndCloseSelf:(UIViewController *)vc{
//        NSArray *viewControlles = self.navigationController.viewControllers;
//        NSMutableArray *newviewControlles = [NSMutableArray array];
//        if ([viewControlles count] > 0) {
//                for (int i=0; i < [viewControlles count]-1; i++) {
//                        [newviewControlles addObject:[viewControlles objectAtIndex:i]];
//                    }
//        }
//        [newviewControlles addObject:vc];
//        [self.navigationController setViewControllers:newviewControlles animated:YES];
//}


/**
 从导航栏中移除自己
 */
- (void)removeSelfFromNavigationController
{
    NSArray * viewControllers = self.navigationController.viewControllers;
    NSMutableArray * newViewControllers = [NSMutableArray arrayWithArray:viewControllers];
    if ([newViewControllers containsObject:self]) {
        [newViewControllers removeObject:self];
    }
    [self.navigationController setViewControllers:newViewControllers animated:YES];
}

@end
