//
//  UINavigationBar+Background.h
//  NavGestureAnimation
//
//  Created by 张博 on 16/10/17.
//  Copyright © 2016年 zhangbo. All rights reserved.
//

#import <UIKit/UIKit.h>
/**
 *  UINavigationBar扩展 可以自定义导航的背景颜色、透明度、偏移量  以及恢复导航默认设置
 */
@interface UINavigationBar (Background)

/**
 清空背景颜色
 */
- (void)clearBackground;


/**
 *  还原默认设置
 */
- (void)ex_reset;


/**
 *  设置背景视图的偏移量
 *
 *  @param translationY 偏移量
 */
- (void)setTranslationY:(CGFloat)translationY;


/**
 *  子视图的透明度
 *
 *  @param alpha 透明度
 */
- (void)ex_setElementsAlpha:(CGFloat)alpha;



@end
