//
//  QGFuLuWebViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGFuLuWebViewController.h"
#import "NSString+QGURLParam.h"
@interface QGFuLuWebViewController ()

@property (nonatomic, strong) NSString * redirect_url;

@end

@implementation QGFuLuWebViewController

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"payReturn" object:nil];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    //注册通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(payBack) name:@"payReturn" object:nil];
}

- (BOOL)navGestureRecognizerShouldBegin:(UIPanGestureRecognizer *)gestureRecognizer
{
    return NO;
}

-(void)payBack
{
    NSLog(@"支付回来了----%@",self.redirect_url);
    self.redirect_url = [self.redirect_url stringByRemovingPercentEncoding];
    NSURL *url = [NSURL URLWithString:self.redirect_url];
    if (!url) {
        //添加编码
        url = [NSURL URLWithString:[NSString urlEncodeString:self.redirect_url]];
    }
    NSMutableURLRequest* request = [NSMutableURLRequest requestWithURL:url cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:60.0];
    [self.myWebView loadRequest:request];
    
}


-(BOOL)webView:(UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType
{
    
    NSString *urlString = request.URL.absoluteString;
    NSString *preStr = @"https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb";
    NSDictionary *headers = [request allHTTPHeaderFields];

    /*
       此处做链接的前缀判断是为了防止在其他链接中加入Referer信息
    */
    if (![[headers objectForKey:@"Referer"] isEqualToString:@"www.xyqb.com://"] && [urlString hasPrefix:preStr])
    {
        //获取URL中的参数
        NSDictionary * urlParam = [urlString getURLParameters];
        //里面只能有一个redirect_url
        if ([urlParam[@"redirect_url"] isKindOfClass:[NSString class]]) {
            self.redirect_url = urlParam[@"redirect_url"];
            //剔除&redirect_url=xxx字段
            NSString * payUrlString = [urlString stringByReplacingOccurrencesOfString:[NSString stringWithFormat:@"&redirect_url=%@",self.redirect_url] withString:@""];
            NSMutableURLRequest *req = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:payUrlString] cachePolicy:NSURLRequestUseProtocolCachePolicy timeoutInterval:60.0];
            req.allHTTPHeaderFields = request.allHTTPHeaderFields;
            //将删除了redirect_url的支付链接，头部添加Referer信息，以便微信支付之后可以返回app
            //Referer对应的域名必须是H5支付域名
            [req setValue:@"www.xyqb.com://" forHTTPHeaderField:@"Referer"];
//            [req setHTTPMethod:@"GET"];
            [self.myWebView loadRequest:req];
        }
    }
    
    return [super webView:webView shouldStartLoadWithRequest:request navigationType:navigationType];
}


@end
