//
//  QGColorNavigationBar.m
//  CreditWallet
//
//  Created by 张博 on 2017/12/4.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGColorNavigationBar.h"
#import "QGBasicUITool.h"
#import "UIView+LayoutSubviewsCallback.h"
#import "Masonry.h"
@interface QGColorNavigationBar ()

/**
 导航栏底部的线条
 */
@property (nonatomic, strong) UIImageView * bottomLineImageView;

/**
 导航渐变色
 */
@property (nonatomic, strong) CAGradientLayer * gradientLayer;

/// 标题
@property (nonatomic, strong, readwrite) UILabel * titleLabel;

@end

@implementation QGColorNavigationBar


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initNormalUI];
    }
    return self;
}


- (instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self = [super initWithCoder:aDecoder]) {
        [self initNormalUI];
    }
    return self;
}


/**
 初始化默认UI
 */
- (void)initNormalUI
{
    self.bottomLineImageView = [UIView creatImageViewWithSuperView:self imageName:nil];
    self.bottomLineImageView.backgroundColor = [UIColor lineSeparatorColorDCDC];
    [self.bottomLineImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self).offset(0);
        make.height.mas_equalTo(.5);
        make.bottom.equalTo(self).offset(0);
    }];
    
    //标题
    self.titleLabel = [UILabel creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_mediumFontOfSize:17] textColor:[UIColor navigationTitleColor] alignment:NSTextAlignmentCenter];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(24);
        make.bottom.inset(15);
        make.centerX.offset(0);
    }];
    
}

/**
 设置偏移量
 
 @param translationY 偏移量的值
 */
- (void)setTranslationY:(CGFloat)translationY
{
    self.transform = CGAffineTransformMakeTranslation(0, translationY);
}



#pragma mark - Setter

- (void)setBottomLineColor:(UIColor *)bottomLineColor
{
    if (_bottomLineColor != bottomLineColor) {
        _bottomLineColor = bottomLineColor;
        self.bottomLineImageView.backgroundColor = bottomLineColor;
    }
}

- (void)setBottomLineIsHidden:(BOOL)bottomLineIsHidden
{
    if (_bottomLineIsHidden != bottomLineIsHidden) {
        _bottomLineIsHidden = bottomLineIsHidden;
        self.bottomLineImageView.hidden = _bottomLineIsHidden;
    }
}

- (void)setIsGradientBar:(BOOL)isGradientBar
{
    if (_isGradientBar != isGradientBar) {
        _isGradientBar = isGradientBar;
        
        self.gradientLayer.hidden = !_isGradientBar;
        self.bottomLineImageView.hidden = _isGradientBar;
    }
}


- (CAGradientLayer *)gradientLayer
{
    if (!_gradientLayer) {
        //渐变色
        CAGradientLayer * gradientLayer = [CAGradientLayer layer];
        gradientLayer.startPoint = CGPointMake(0, 0.5);
        gradientLayer.endPoint = CGPointMake(1, 0.5);
        gradientLayer.colors = [UIColor gradientColors];
        [self.layer addSublayer:gradientLayer];
        
        __weak typeof(self) weakSelf = self;
        self.layoutSubviewsCallback = ^(UIView * _Nonnull view) {
            gradientLayer.frame = weakSelf.bounds;
        };
        
        _gradientLayer = gradientLayer;
    }
    return _gradientLayer;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
