//
//  QGBaseWebViewController.m
//  CreditWallet
//
//  Created by 张博 on 16/10/27.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGBaseWebViewController.h"
#import "NSString+CreditWallet.h"
#import "QGBaseWebViewController+QGJSLogic.h"
#import "QGThirdPlatformService.h"
#import "QGHUDManager.h"
#import "QGDeviceTool.h"
#import "QGToolsConfig.h"
#import "UIViewController+ChooseContactPhone.h"
#import "QGApplicationOpenURL.h"
#import "SystemManager.h"
#import "QGShareView.h"
#import "QGBaseWebViewController+FaceSDK.h"
#import "QGBaiChuanManager.h"
#import "QGApplicationOpenURL.h"

#import "QGAlertView.h"
#import "QGSafeBindSmsVerifyViewController.h"
#import "QGLoginRequestApi.h"

//神策
#import "SensorsAnalyticsSDK.h"
//友盟
#import <UMAnalytics/MobClick.h>
#import <AVKit/AVKit.h>
@interface QGBaseWebViewController () <UIWebViewDelegate>

@property (nonatomic, strong) ZHJSContextHelper *jsHelper;

/**
 *  JS作用域 子类用于新增函数供JS端调用
 */
@property (nonatomic, strong) JSContext *jContext;

/// 平台数组
@property (nonatomic, strong) NSArray * platfromArray;

/// 分享模型
@property (nonatomic, strong) QGShareModel * shareModel;

@end

@implementation QGBaseWebViewController

/**
 检查入参是否正确 需要子类重写
 
 @param param 入参
 @return 返回参数检查是否通过
 */
- (BOOL)checkParameters:(NSDictionary *)param {
    if (param[@"urlString"]) {
        return YES;
    }
    return NO;
}

/**
 传参函数 需要子类重写
 
 进入页面前需要传递该页面必须的参数
 @param param 入参
 */
- (void)transferParameters:(NSDictionary *)param {
    if (param[@"urlString"]) {
        self.urlString = param[@"urlString"];
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initBaseNormalUI];
    [self initBaseNormalRequest];
}

- (void)initBaseNormalUI {
    
    //关闭手势
    //测试提出需要禁用手势，产品已确认关闭webView页面返回手势
    self.isClosePopGesture = YES;
    
    self.myWebView.delegate = self;
#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000)
    if (@available(iOS 11.0, *)) {
        if ([self.myWebView.scrollView respondsToSelector:@selector
                                       (contentInsetAdjustmentBehavior)]) {
            self.myWebView.scrollView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
        }
    }
#endif

    //自定义NavigationItem
    [self setupNavigationItem];
}

- (void)setupNavigationItem {
    CGRect rect = CGRectMake(-15, 0, 100, 40);
    UIView *leftNavItemView = [[UIView alloc] initWithFrame:rect];
    leftNavItemView.backgroundColor = [UIColor clearColor];

    UIButton *goBackBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [goBackBtn setImage:[UIImage imageNamed:@"web-back"] forState:UIControlStateNormal];
    goBackBtn.frame = CGRectMake(0, 0, 60, 40);
    [goBackBtn addTarget:self action:@selector(goBackClick:) forControlEvents:UIControlEventTouchUpInside];
    [leftNavItemView addSubview:goBackBtn];
    goBackBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    
    
    UIBarButtonItem *negativeSpacer = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFixedSpace target:nil action:nil];
    negativeSpacer.width = -10; //偏移距离  -向左偏移, +向右偏移
    self.navigationItem.leftBarButtonItems = @[ negativeSpacer, [[UIBarButtonItem alloc] initWithCustomView:leftNavItemView] ];
}


/**
 *  返回上一级
 */
- (void)goBackClick:(UIButton *)sender {

    if (self.myWebView.canGoBack) {
        [self.myWebView goBack]; //返回前一画面
    } else {
        [self pop];
    }
}
/**
 *  关闭本页面
 */
- (void)goCloseClick:(UIButton *)sender {

    [self pop];
}

- (void)pop {
    [self.navigationController popViewControllerAnimated:YES];
}

/**
 *  调用JS函数
 *
 *  @param method    回调方法名
 *  @param arguments 传参
 */
- (void)callJSWithMethod:(NSString *)method callWithArguments:(NSArray *)arguments {
    if (!arguments) {
        return;
    }
    //如果存在记录的web线程，则在其中调用
    if (self.jsHelper.webviewThread) {
        [self performSelector:@selector(OCCallJSOnWebThread:) onThread:self.jsHelper.webviewThread withObject:@{@"arguments" : arguments, @"method" : method} waitUntilDone:NO];
    } else {
        [self.jContext[method] callWithArguments:arguments];
    }
}

///在webThread中调用JS方法
- (void)OCCallJSOnWebThread:(NSDictionary *)jsInfoDic {
    NSArray *arguments = jsInfoDic[@"arguments"];
    NSString *method = jsInfoDic[@"method"];
    //安全判断
    if (arguments && method) {
        [self.jContext[method] callWithArguments:arguments];
    }
}

- (void)initBaseNormalRequest {
    //芝麻信用分特殊处理
    if ([self.urlString isContainOfString:@"zmxy.com"]) {
        [self baseLoadUrl];
    } else {
        [self baseCheckLogin];
    }
}

//检查URL 是否包含 {phone} {token} 如果包含需要检测登录
- (void)baseCheckLogin {
    //移除编码格式
    self.urlString = [self.urlString stringByRemovingPercentEncoding];

    //替换默认配置
    self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{registerFrom}" withString:registerFrom];
    self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{appChannel}" withString:appChannel];
    self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{version}" withString:XcodeAppVersion];
    
    if ([QGUserInfo sharedUserInfo].isLogin) {
        NSString *token = [QGUserInfo sharedUserInfo].token;
        NSString *userName = [QGUserInfo sharedUserInfo].userName;
        NSString * uuid = [QGUserInfo sharedUserInfo].uuid;
        //安全处理
        if (token.length == 0) {
            token = @"";
        }
        if (userName.length == 0) {
            userName = @"";
        }
        if (uuid.length == 0) {
            uuid = @"";
        }
        
        self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{token}" withString:token];
        self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{phone}" withString:userName];
        self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{uuid}" withString:uuid];
    } else {
        self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{token}" withString:@""];
        self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{phone}" withString:@""];
        self.urlString = [self.urlString stringByReplacingOccurrencesOfString:@"{uuid}" withString:@""];
    }

    [self addingPercent];
}

- (void)addingPercent {
    [self baseLoadUrl];
}

- (void)baseLoadUrl {
    //此处做下兼容，如果默认能转成url 则不编码，如果不能，则编码
    NSURL *url = [NSURL URLWithString:self.urlString];
    if (!url) {
        //添加编码
        url = [NSURL URLWithString:[NSString urlEncodeString:self.urlString]];
    }
    if ([self.urlString rangeOfString:@"clouddn.com"].location != NSNotFound) {
        //条件为真，表示字符串searchStr包含一个自字符串substr
        NSData *data = [NSData dataWithContentsOfURL:url];
        [self.myWebView loadData:data MIMEType:@"text/html" textEncodingName:@"UTF-8" baseURL:url];

    } else {
        //条件为假，表示不包含要检查的字符串
        [self.myWebView loadRequest:[NSURLRequest requestWithURL:url]];
    }
    self.jsHelper = [[ZHJSContextHelper alloc] init];
    self.jsHelper.delegate = self;
}

- (UIWebView *)myWebView {
    if (!_myWebView) {
        CGFloat navStatusHeight = [DeviceAdaptation getNavBarAndStatusBarHeight];
        _myWebView = [[UIWebView alloc] initWithFrame:CGRectMake(0, navStatusHeight, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT - navStatusHeight)];
        _myWebView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        _myWebView.dataDetectorTypes = UIDataDetectorTypeNone;
        _myWebView.delegate = self;
        [self.view addSubview:_myWebView];
    }
    return _myWebView;
}

#pragma mark - UITableViewDelegate
- (BOOL)webView:(UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType {
    
    ///此处获取title 是为了配合H5页面内部的router跳转
    self.navigationItem.title = [webView stringByEvaluatingJavaScriptFromString:@"document.title"];
    
    if ([[SensorsAnalyticsSDK sharedInstance] showUpWebView:webView WithRequest:request enableVerify:YES]) {
        return NO;
    }
    return YES;
}

- (void)webViewDidFinishLoad:(UIWebView *)webView {
    self.jContext = [webView valueForKeyPath:@"documentView.webView.mainFrame.javaScriptContext"];
    self.jContext[@"xyqbNative"] = _jsHelper;
    //异常回调
    self.jContext.exceptionHandler = ^(JSContext *context, JSValue *exception) {
        NSLog(@"error:%@", exception);
    };
    //    self.title = [webView stringByEvaluatingJavaScriptFromString:@"document.title"];

    self.navigationItem.title = [webView stringByEvaluatingJavaScriptFromString:@"document.title"];

    //导流JS注入
    [self guideInjectJS];
}

- (void)webView:(UIWebView *)webView didFailLoadWithError:(NSError *)error {
}

#pragma mark - JSCallOCMethod


//微信分享
//- (void)JSCallOCMethodWXShare:(NSDictionary *)shareDic {
//    QGGoodsShareView *shareSheet = [[QGGoodsShareView alloc] init];
//    [shareSheet showAnimation:YES];
//
//    __weak typeof(self) weakSelf = self;
//    shareSheet.shareBlock = ^(NSInteger index) {
//        if (index == 0) {
//            [weakSelf shareWithType:HMShare_WeChatSessionType dictionary:shareDic];
//        } else if (index == 1) {
//            [weakSelf shareWithType:HMShare_WeChatTimelineType dictionary:shareDic];
//        } else if (index == 2) {
//            [weakSelf shareWithType:HMShare_QQClientType dictionary:shareDic];
//        } else if (index == 3) {
//            [weakSelf shareWithType:HMShare_QQZoneType dictionary:shareDic];
//        }
//        //复制链接
//        else if (index == 4) {
//            UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
//            NSString *shareUrl = shareDic[@"pageUrl"];
//            if (shareUrl.length > 0) {
//                pasteboard.string = shareUrl;
//                [QGHUDManager showHud:@"已复制到粘贴板"];
//            }
//        }
//    };
//}


//关闭浏览器
- (void)JSCallOCMethodCloseBrowser:(id)value {
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


///关闭当前页面，并重新打开一个新的协议
-(void)JSCallOCMethodReopenBrowserWithNewUrl:(id)value
{
    [self.navigationController popViewControllerAnimated:NO];
    if ([value isKindOfClass:[NSDictionary class]]) {
        NSString * newUrl = value[@"newUrl"];
        if (self.callBackBlock && ![NSString isEmpty:newUrl]) {
            self.callBackBlock(WebView_ReopenBrowserWithNewUrl, @{@"urlString":newUrl});
        }
        
    }
}

// VCC 还款页面的刷新操作，比如还款完成、分期成功
- (void)JSCAllOCMethodVCCRepaymentReload:(id)value
{
    [[NSNotificationCenter defaultCenter] postNotificationName:VCCRepaymentReloadNotification object:nil];
}

#pragma mark - 定义js与native通用交互

///js与native通用交互
- (void)JSCallOCMethodJSEvent:(NSDictionary *)eventDic
{
    NSString * event = eventDic[@"event"];
    NSLog(@"JS Event = %@",event);
    //微信登录
    if ([event isEqualToString:@"wxLogin"]) {
        [self weChatLoginEvent];
    }
    //客服入口
    else if ([event isEqualToString:@"showCustomerService"])
    {
        [self showServiceButtonEvent:eventDic];
    }
    //添加分享入口
    else if ([event isEqualToString:@"showShareButton"])
    {
        [self showShareButtonEvent:eventDic];
    }
    //直接展示分享视图
    else if ([event isEqualToString:@"showShareView"])
    {
        [self showShareViewEvent:eventDic];
    }
    //友盟埋点
    else if ([event isEqualToString:@"umengTrack"])
    {
        [self umengTrackEvent:eventDic];
        
    }else if ([event isEqualToString:@"openfaceIDIDCard"]){  /// 调用OCR
        if ([self respondsToSelector:@selector(openfaceIDIDCard:)]) {
             [self openfaceIDIDCard:eventDic];
        }
    }
    //打开百川的链接
    else if ([event isEqualToString:@"openBaiChuanUrl"])
    {
        [self openBaiChuanUrl:eventDic];
    }
    /// 淘宝联盟授权结果
    else if ([event isEqualToString:@"notifyTaobaoAuth"]){
        if ([self respondsToSelector:@selector(notifyBaiChuanResult:)]) {
            [self notifyBaiChuanResult:eventDic];
        }
    }
    /// 打开商品列表
    else if ([event isEqualToString:@"toAppMallGoodsList"]){
        if ([self respondsToSelector:@selector(toGoodsList:)]) {
            [self toGoodsList:eventDic];
        }
    }
    /// 获取token 如果客户端未登录，则需要登录后回传token
    else if ([event isEqualToString:@"getToken"])
    {
        [self JSGetToken];
    }
    //关闭浏览器
    else if ([event isEqualToString:@"closeBrowser"])
    {
        [self.navigationController popViewControllerAnimated:YES];
    }
    //关闭并打开新的页面
    else if ([event isEqualToString:@"reopenBrowserWithNewUrl"])
    {
        [self reopenBrowserWithNewUrl:eventDic];
    }
    //通知我的账单页刷新
    else if ([event isEqualToString:@"vccRepaymentReload"])
    {
        [[NSNotificationCenter defaultCenter] postNotificationName:VCCRepaymentReloadNotification object:nil];
    }
    //打开原生播放器
    else if ([event isEqualToString:@"openAVPlayer"])
    {
        [self openAVPlayerEvent:eventDic];
    }
    //新增
    else if ([event isEqualToString:@"openNewUrl"])
    {
        [self openNewUrl:eventDic];
    /// 选择的银行卡
    }else if ([event isEqualToString:@"selectBankCard"]){
        [self selectBankCard:eventDic];
    }
}



#pragma mark - Private

/// 微信登录
- (void)weChatLoginEvent
{
    @weakify(self);
    
    [[QGThirdPlatformService shareInstance] wxAuthWithSuccess:^(QGWechatLoginInfoModel * infoModel) {
        @strongify(self);
        /// 查询微信号是否可用
        [self queryAuthStatusWithOpenId:infoModel.unionid complete:^{
            @strongify(self);
            /// 身份验证
            QGSafeBindSmsVerifyViewController *vc = [[QGSafeBindSmsVerifyViewController alloc]init];
            vc.wxModel = infoModel;
            vc.bindSuccessBlock = ^(BOOL Success) {
                NSDictionary *callDic = @{@"event" : @"wxAuthSuccessNew",
                                          @"data" : [infoModel yy_modelToJSONObject]};
                [self callJSWithMethod:@"xyqbNativeEvent" callWithArguments:@[callDic]];
            };
            [self.navigationController pushViewController:vc animated:YES];
        }];
    }];
}


/// 友盟埋点
- (void)umengTrackEvent:(NSDictionary *)eventDic
{
    NSDictionary * dataDic = eventDic[@"data"];
    if ([dataDic isKindOfClass:[NSDictionary class]]) {
        //H5提供
        NSString * eventID = dataDic[@"umengEventID"];
        NSDictionary * attributesDic = dataDic[@"attributes"];
        [MobClick event:eventID attributes:attributesDic];
    }
}


/// 显示客服按钮
- (void)showServiceButtonEvent:(NSDictionary *)eventDic
{
    NSDictionary * dataDic = eventDic[@"data"];
    if ([dataDic isKindOfClass:[NSDictionary class]]) {
        NSString * navUrl = dataDic[@"navUrl"];
        @weakify(self);
        [self custemRightBarButtonItemWithTitle:nil imageName:@"service_right_barbutton" action:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self serviceButtonClickWithNavUrl:navUrl];
        }];
    }
}


/// 显示分享按钮，并且转化数据
- (void)showShareButtonEvent:(NSDictionary *)eventDic
{
    NSDictionary * dataDic = eventDic[@"data"];
    //解析分享平台相关数据
    [self getShareDataSource:dataDic];
    
    @weakify(self);
    [self custemRightBarButtonItemWithTitle:nil imageName:@"share_right_barbutton" action:^(UIButton * _Nonnull button) {
        @strongify(self);
        [self showShareView];
    }];
}

/// 显示分享视图时间
- (void)showShareViewEvent:(NSDictionary *)eventDic
{
    NSDictionary * dataDic = eventDic[@"data"];
    //解析分享平台相关数据
    [self getShareDataSource:dataDic];
    [self showShareView];
}

///调起分享视图
- (void)showShareView
{
    QGShareView * shareView = [[QGShareView alloc] initWithItems:self.platfromArray shareModel:self.shareModel];
    [shareView showInView:nil];
    
    shareView.sharingBlock = ^(QGShareItemType shareItemType) {
        //分享点击埋点
        [MobClick event:@"ShareButtonClickEvent"];
    };
}



/// 获取分享的平台相关数据
- (void)getShareDataSource:(NSDictionary *)dataDic
{
    //获取支持平台
    NSArray * platformArray = dataDic[@"platform"];
    NSDictionary * platformDic = [NSDictionary dictionaryWithObjects:@[@(QGShareItemTypeWeChat),@(QGShareItemTypeTimeLine),@(QGShareItemTypeQQ),@(QGShareItemTypeQQZone),@(QGShareItemTypeCopyLink)] forKeys:@[@"weChat",@"timeLine",@"QQ",@"QQZone",@"CopyLink"]];
    NSMutableArray * platformResult = [NSMutableArray arrayWithCapacity:0];
    for (NSString * platform in platformArray) {
       [platformResult addObject:platformDic[platform]];
    }
    self.platfromArray = platformResult;
    
    //获取分享的模型
    self.shareModel = [QGShareModel yy_modelWithJSON:dataDic[@"shareDic"]];
}


/// 客服点击事件
- (void)serviceButtonClickWithNavUrl:(NSString *)navUrl
{
    if ([QGUserInfo sharedUserInfo].login) {
       [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBaseWebViewController) parameters:@{@"urlString":[NSString isEmpty:navUrl] ? VCCServiceUrl : navUrl} handlerBlock:nil];
    }else{
        [self showLoginViewController];
    }
}

///通过百川打开URL
- (void)openBaiChuanUrl:(NSDictionary *)dataDic
{
    if (![QGUserInfo sharedUserInfo].login) {
        [self showLoginViewController];
        return;
    }
    
    NSDictionary *data = dataDic[@"data"];
    NSString * openUrl = data[@"openUrl"];
    NSString * tbPid = data[@"tbPid"];
    [[QGBaiChuanManager shareInstance] openURL:openUrl taokePid:tbPid navigationController:self.navigationController];
}

/// 获取淘宝联盟授权结果
/// @param dic 参数
- (void)notifyBaiChuanResult:(NSDictionary *)dic
{
    NSDictionary *data = dic[@"data"];
    NSString *message = data[@"message"];
    
    BOOL alimamaAuth = [[data objectForKey:@"taobaoAuth"] boolValue];
    if (alimamaAuth) {
        QGUserInfo.sharedUserInfo.alimamaAuth = YES;
        /// 授权成功通知
        [[NSNotificationCenter defaultCenter] postNotificationName:AlimamaAuthSuccessNotification object:nil];
        [QGHUDManager showHud:@"授权成功"];
        [self analyticsWithSuccess:YES message:nil];
        [self.navigationController popViewControllerAnimated:YES];
    }else{
        [QGHUDManager showHud:message ? message :@"授权失败"];
        QGUserInfo.sharedUserInfo.alimamaAuth = NO;
        [self analyticsWithSuccess:NO message:message ? message : @"授权失败"];
    }
}

/// 授权结果埋点统计
/// @param success 授权成功与否success|failed
/// @param msg success ? @"授权成功":msg
- (void)analyticsWithSuccess:(BOOL)success message:(NSString *)msg
{
    NSString *value = success ? @"success":@"failed";
    if (success) {
        msg = @"授权成功";
    }
    NSString *phone;
    if (QGUserInfo.sharedUserInfo.isLogin) {
        phone = QGUserInfo.sharedUserInfo.userName;
    }
    QGAppBusinessStateEvent *event = [QGAppBusinessStateEvent abseEventWithPage:@"淘宝联盟授权" action:@"淘宝联盟授权结果" value:value code:nil desc:msg phone:phone];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/// 打开商品列表
/// @param dic 参数
- (void)toGoodsList:(NSDictionary *)dic
{
    NSDictionary *data = dic[@"data"];
    NSString *materialId = data[@"materialId"];
    NSString *title = data[@"title"];
    NSString *term = data[@"term"];
    /// 一级类目标题
    NSString *levelName = data[@"levelName"];
    
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    if (materialId) {
        [param setObject:materialId forKey:@"materialId"];
    }
    if (term) {
        [param setObject:term forKey:@"term"];
    }
    if (title) {
        [param setObject:title forKey:@"title"];
    }
    
    /// 一级类目标题
    if (levelName) {
        [param setObject:levelName forKey:@"levelName"];
    }
    /// 是否二级类目
    [param setObject:@(YES) forKey:@"isLevelTwo"];
    
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallHomeGoodsListViewController) parameters:param handlerBlock:NULL];
}


/// web端从APP获取token
- (void)JSGetToken
{
    if (![QGUserInfo sharedUserInfo].isLogin) {
        @weakify(self);
        [self showLoginViewControllerCompletion:^{
            @strongify(self);
            [self JSGetToken];
        }];
        return;
    }
    
    //登录成功后回传token
    NSMutableDictionary * param = [NSMutableDictionary dictionaryWithCapacity:0];
    [param setObject:@"getTokenSuccess" forKey:@"event"];
    NSDictionary * dataDic = @{@"phone":[QGUserInfo sharedUserInfo].userName,@"token":[QGUserInfo sharedUserInfo].token};
    [param setObject:dataDic forKey:@"data"];
    [self callJSWithMethod:@"xyqbNativeEvent" callWithArguments:@[param]];
}


///关闭当前页面，并重新打开一个新的协议
-(void)reopenBrowserWithNewUrl:(NSDictionary *)dic
{
    [self.navigationController popViewControllerAnimated:NO];
    if ([dic[@"data"] isKindOfClass:[NSDictionary class]]) {
        NSString * newUrl = dic[@"data"][@"newUrl"];
        if (self.callBackBlock && ![NSString isEmpty:newUrl]) {
            self.callBackBlock(WebView_ReopenBrowserWithNewUrl, @{@"urlString":newUrl});
        }
        
    }
}


/// 打开一个新的协议
- (void)openNewUrl:(NSDictionary *)dic
{
    if ([dic[@"data"] isKindOfClass:[NSDictionary class]]) {
        NSString * newUrl = dic[@"data"][@"newUrl"];
        if (![NSString isEmpty:newUrl]) {
            [QGApplicationOpenURL handleAllSupportUrl:newUrl];
        }
    }
}


/// 打开原生播放器
- (void)openAVPlayerEvent:(NSDictionary *)dic
{
    NSDictionary * data = dic[@"data"];
    NSString * videoUrl = data[@"videoUrl"];
    if (![NSString isEmpty:videoUrl]) {
        //获取视频路径
        NSURL *webVideoUrl = [NSURL URLWithString:videoUrl];
        //创建AVPlayer
        AVPlayer *avPlayer = [[AVPlayer alloc] initWithURL:webVideoUrl];
        //使用AVPlayer创建AVPlayerViewController，并跳转播放界面
        AVPlayerViewController *avPlayerVC =[[AVPlayerViewController alloc] init];
        avPlayerVC.player = avPlayer;
        [self presentViewController:avPlayerVC animated:YES completion:nil];
        
    }
}

/// 选择银行卡号信息
- (void)selectBankCard:(NSDictionary *)dic
{
    NSDictionary *data = dic[@"data"];
    if ([dic[@"data"] isKindOfClass:[NSDictionary class]]) {
        if (self.callBackBlock) {
            self.callBackBlock(kWebView_selectBankCardInfoKey, data);
        }
    }
}

#pragma mark - 微信授权查询接口

/// 查询当前的微信id是否可以被绑定
/// @param unionId 唯一id
/// @param completeBlock 可用完成回调
- (void)queryAuthStatusWithOpenId:(NSString *)unionId complete:(void(^)(void))completeBlock
{
    if (unionId == nil) return;
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    
    [param setObject:unionId forKey:@"authId"];
    //  1:微信 2：apple 3：淘宝 4：百川
    [param setObject:@(1) forKey:@"authType"];
    
    [QGHUDManager showHud:nil];
   // [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodBindAvailable]
    //@"http://yapi.quantgroups.com/mock/305/vcc/external/login/auth_status/authId"
    [networking GET:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodBindAvailable] parameters:param success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            if (completeBlock) {
                completeBlock();
            }
        }else{
            NSString *businessCode = responseObject[@"businessCode"];
            /// 已被绑定,不可用
            if ([businessCode isEqualToString:@"1012"]) {
                QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"该微信已绑定其他真享生活账号，无法进行授权！" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
                [alert showInView:self.view];
            }else{
                NSString *msg = responseObject[@"msg"] ? responseObject[@"msg"]:@"授权错误";
                [QGHUDManager showHud:msg];
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络错误,请稍后再试"];
    }];
}


- (void)dealloc {
    //资源释放的时候，停止webView加载 并将webView的delegate置为nil 减少某些机型可能触发的bug
    if (_myWebView) {
        [self.myWebView stopLoading];
        self.myWebView.delegate = nil;
    }
    
}



@end
