//
//  QGBaseViewController.m
//  CreditWallet
//
//  Created by 张博 on 16/10/21.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGBaseViewController.h"
#import "QGColorNavigationBar.h"
#import "UINavigationBar+Background.h"
#import "UINavigationController+Swizzing.h"
#import "SystemManager.h"
#import "QGCustomTitleVIew.h"

@interface QGBaseViewController () <UIAlertViewDelegate>

/**
 管理导航颜色
 */
@property (nonatomic, strong, readwrite) QGColorNavigationBar *colorViewBar;

/**
 状态栏是否是白色
 */
@property (nonatomic, assign) BOOL statusBarLight;

@end

@implementation QGBaseViewController

#pragma mark - 外部直接调用的刷新方法

/**
 提供给外部的刷新本页面请求接口
 子类可以根据需要决定是否重写
 */
- (void)reloadRequestMehtod {
}

/**
 检查入参是否正确 需要子类重写
 
 @param param 入参
 @return 返回参数检查是否通过
 */
- (BOOL)checkParameters:(NSDictionary *)param {
    return NO;
}

/**
 传参函数 需要子类重写
 
 进入页面前需要传递该页面必须的参数
 @param param 入参
 */
- (void)transferParameters:(NSDictionary *)param {
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [SystemManager shareInstance].currentViewController = self;
    
    //当前父视图为导航栏，说明是非嵌套容器
    if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
         [SystemManager shareInstance].currentNav = self.navigationController;
    }
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];

}

#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000)

/**
 在viewDidAppear之前，viewWillAppear之后
 */
- (void)viewSafeAreaInsetsDidChange {
    [super viewSafeAreaInsetsDidChange];
}
#endif


- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    //基础设置
    //设置UIRectEdgeAll是为了兼容透明导航栏
    self.edgesForExtendedLayout = UIRectEdgeAll;
    //viewController里面此属性最好关闭，否则容易引发意向不到的效果
    if (iOS11) {
        //custom code
    } else {
        self.automaticallyAdjustsScrollViewInsets = NO;
    }
    //初始化导航栏颜色视图
    [self initColorNavBar];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - 导航栏背景颜色/透明度相关设置
/**
 初始化导航栏颜色视图
 */
- (void)initColorNavBar {
//    NSLog(@"______%@",self.parentViewController);
    //如果父容器是导航，则说明是需要包含导航栏
    if ([self.parentViewController isKindOfClass:[UINavigationController class]]) {
        self.colorViewBar = [[QGColorNavigationBar alloc] initWithFrame:CGRectMake(0, 0, CGRectGetWidth(self.view.frame), [DeviceAdaptation getNavBarAndStatusBarHeight])];
        self.colorViewBar.backgroundColor = [UIColor navigationBarColor];
        [self.view addSubview:self.colorViewBar];
        [self.colorViewBar mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.left.right.mas_equalTo(self.view);
            if (@available(iOS 11.0, *)) {
                make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideTop);
            } else {
                make.bottom.equalTo(self.mas_topLayoutGuideBottom);
                
            }
        }];
        //设置系统的导航条为透明
        [self.navigationController.navigationBar clearBackground];
    }
}

/**
 状态栏一直位于最上层
 */
- (void)viewWillLayoutSubviews {
    [super viewWillLayoutSubviews];
    if (self.colorViewBar) {
        [self.view bringSubviewToFront:self.colorViewBar];
    }
}


/**
 导航栏上添加View
 */
- (void)addNavBarSubView:(UIView *)view
{
    if (view) {
        [self.colorViewBar addSubview:view];
    }
    
}

/**
 设置当前控制器导航栏的颜色
 */
- (void)setNavBarBackgroundColor:(UIColor *)backgroundColor {
    //设置系统的导航条为透明
    [self.navigationController.navigationBar clearBackground];
    //设置当前控制器颜色管理的bar
    [self.colorViewBar setBackgroundColor:backgroundColor];
}

/**
 设置当前控制器导航栏的透明度
 */
- (void)setNavBarBackgroundAlpha:(CGFloat)alpha {
    //设置系统的导航条为透明
    [self.navigationController.navigationBar clearBackground];
    //设置当前控制器颜色管理的bar
    [self.colorViewBar setAlpha:alpha];
//    _customTitleView.alpha = alpha;
}

/**
 *  设置当前控制器导航栏的偏移量
 */
- (void)setNavBarTranslationY:(CGFloat)translationY {
    //系统导航栏偏移量
    [self.navigationController.navigationBar setTranslationY:translationY];
    //当前控制器持有导航栏偏移量
    [self.colorViewBar setTranslationY:translationY];
}

/**
 *  设置当前控制器导航栏底部线条是否隐藏
 */
- (void)setNavBarBottomLineHidden:(BOOL)isHidden {
    [self.colorViewBar setBottomLineIsHidden:isHidden];
}

/**
 设置当前控制器是否是渐变色导航栏
 */
- (void)setNavBarIsGradientBar:(BOOL)isGradientBar
{
    [self.colorViewBar setIsGradientBar:isGradientBar];
}


/**
 *  还原当前视图导航栏默认设置
 */
- (void)resetNavBar {
    //重置偏移量
    [self setNavBarTranslationY:0];
    //重置颜色
    [self setNavBarBackgroundColor:[UIColor navigationBarColor]];
    //重置透明度
    [self setNavBarBackgroundAlpha:1];
}

- (void)setStatuBarLightContent:(BOOL)isLight
{
    if (self.statusBarLight != isLight) {
        self.statusBarLight = isLight;
        [self setNeedsStatusBarAppearanceUpdate];
    }
}

- (void)setupNavBarTitleColor:(UIColor *)color title:(NSString *)title
{
    
    //设置title后，导航栏上面的title会被清空，由底部导航条接管
    if (title) {
        self.colorViewBar.titleLabel.text = title;
        self.title = nil;
    }
    
    if (color) {
        self.colorViewBar.titleLabel.textColor = color;
    }
    
}



- (UIStatusBarStyle)preferredStatusBarStyle
{
    return self.statusBarLight ? UIStatusBarStyleLightContent:UIStatusBarStyleDefault;
}


- (void)dealloc {
    NSLog(@"___%@ dealloc", self);
}



@end
