//
//  QGBaseViewController.h
//  CreditWallet
//
//  Created by 张博 on 16/10/21.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "UIViewController+Gesture.h"
#import "UIViewController+CommonConfig.h"
#import "QGBasicUITool.h"
#import "DeveloperFileManager.h"
#import "QGHUDManager.h"
#import "QGTalosNetwork.h"
#import "QGBatchOperationManager.h"
#import "QGColorNavigationBar.h"
//神策
#import "SensorsAnalyticsSDK.h"
#import "QGAnalyticsService.h"
@interface QGBaseViewController : UIViewController<ViewControllerGestureDelegate>

/**
 外部用来约束
 */
@property (nonatomic, strong, readonly) QGColorNavigationBar * _Nonnull colorViewBar;

#pragma mark - 设置导航栏相关

/**
 导航栏上添加View
 */
- (void)addNavBarSubView:(UIView *_Nonnull)view;

/**
 设置当前控制器导航栏的颜色
 */
- (void)setNavBarBackgroundColor:(UIColor *_Nonnull)backgroundColor;

/**
 设置当前控制器导航栏的透明度
 */
- (void)setNavBarBackgroundAlpha:(CGFloat)alpha;

/**
 *  设置当前控制器导航栏的偏移量
 */
- (void)setNavBarTranslationY:(CGFloat)translationY;

/**
 *  设置当前控制器导航栏底部线条是否隐藏
 */
- (void)setNavBarBottomLineHidden:(BOOL)isHidden;

/**
 设置当前控制器是否是渐变色导航栏
 */
- (void)setNavBarIsGradientBar:(BOOL)isGradientBar;

/**
 *  还原当前视图导航栏默认设置
 */
- (void)resetNavBar;

/**
 设置导航栏标题  自动生成titleView

 @param color 颜色
 @param title 标题
 */
- (void)setupNavBarTitleColor:(nullable UIColor *)color title:(nullable NSString *)title;

/**
 设置状态栏白色

 @param isLight 是否白色
 */
- (void)setStatuBarLightContent:(BOOL)isLight;




#pragma mark - 组件化相关
/**
 检查入参是否正确 需要子类重写
 
 @param param 入参
 @return 返回参数检查是否通过
 */
- (BOOL)checkParameters:(NSDictionary *_Nullable)param;

/**
 传参函数 需要子类重写
 
 进入页面前需要传递该页面必须的参数
 @param param 入参
 */
- (void)transferParameters:(NSDictionary *_Nullable)param;

#pragma mark - 外部直接调用的刷新方法

/**
 提供给外部的刷新本页面请求接口
 子类可以根据需要决定是否重写
 */
- (void)reloadRequestMehtod;





@end
