//
//  QGBaseTableViewController.m
//  CreditWallet
//
//  Created by 张博 on 16/10/21.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGBaseTableViewController.h"
@interface QGBaseTableViewController ()

@property (nonatomic, strong) UITableView *listView;

/**
 列表控件的原始frame
 */
@property (nonatomic, assign) CGRect originRect;

@end

@implementation QGBaseTableViewController

- (void)dealloc {
    //安全处理
    if (_listView) {
        self.listView.delegate = nil;
        self.listView.dataSource = nil;
    }
}

- (instancetype)init {
    if (self = [super init]) {
        self.tableViewStyle = UITableViewStylePlain;
    }
    return self;
}

- (UITableView *)tableView {
    return self.listView;
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self addObserver];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.tableView endEditing:YES];
    [self removeObserver];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initNormalListView];
}


///初始化tableView
- (void)initNormalListView
{
    CGFloat navStatusHeight = [DeviceAdaptation getNavBarAndStatusBarHeight];
    if (!self.listView) {
        self.listView = [[UITableView alloc] initWithFrame:CGRectMake(0, navStatusHeight, self.view.frame.size.width, self.view.frame.size.height - navStatusHeight) style:self.tableViewStyle];
        self.listView.backgroundColor = [UIColor whiteColor];
    }
    
    if (!CGRectEqualToRect(CGRectZero, self.originRect)) {
        self.listView.frame = self.originRect;
    }
    
    self.listView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    self.listView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.originRect = self.listView.frame;
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.tableView];
    
#if (__IPHONE_OS_VERSION_MAX_ALLOWED >= 110000)
    if (@available(iOS 11.0, *)) {
        if ([self.listView respondsToSelector:@selector
             (contentInsetAdjustmentBehavior)]) {
            self.listView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
        }
    }
#endif
}

- (void)setIsBelowNavBar:(BOOL)isBelowNavBar {
    if (_isBelowNavBar != isBelowNavBar) {
        _isBelowNavBar = isBelowNavBar;
        [self resetTableViewFrame];
    }
}

- (void)setIsAboveTabBar:(BOOL)isAboveTabBar {
    if (_isAboveTabBar != isAboveTabBar) {
        _isAboveTabBar = isAboveTabBar;
        [self resetTableViewFrame];
    }
}

- (void)setDistanceBottom:(CGFloat)distanceBottom
{
    if (_distanceBottom != distanceBottom) {
        _distanceBottom = distanceBottom;
        [self resetTableViewFrame];
    }
}

- (void)setTableViewStyle:(UITableViewStyle)tableViewStyle
{
    if (_tableViewStyle != tableViewStyle) {
        _tableViewStyle = tableViewStyle;
        
        if (self.listView) {
            [self.listView removeFromSuperview];
            self.listView.delegate = nil;
            self.listView.dataSource = nil;
            self.listView = nil;
            
            [self initNormalListView];
        }
    }
}

- (void)resetTableViewFrame {
    CGFloat navStatusHeight = self.isBelowNavBar ? 0 : [DeviceAdaptation getNavBarAndStatusBarHeight];
    CGFloat tabbarHeight = self.isAboveTabBar ? [DeviceAdaptation getTabBarHeight] : 0;;
    self.listView.frame = CGRectMake(0, navStatusHeight, CGRectGetWidth(self.view.frame), CGRectGetHeight(self.view.frame) - navStatusHeight - tabbarHeight - self.distanceBottom);
    self.listView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    self.originRect = self.listView.frame;
}

- (void)addObserver {
    //监听键盘
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillShow:) name:UIKeyboardWillShowNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillHidden:) name:UIKeyboardWillHideNotification object:nil];
}

- (void)removeObserver {
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillShowNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillHideNotification object:nil];
}

//键盘将要显示回调
- (void)keyboardWillShow:(NSNotification *)notification {
    NSDictionary *userInfo = notification.userInfo;
    CGRect keyboardBounds = [[userInfo objectForKey:UIKeyboardFrameEndUserInfoKey] CGRectValue];
    //获取键盘动画的duration
    CGFloat duration = [[userInfo objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue];
    //获取键盘的高度，计算textField需要平移的高度
    CGFloat deltaY = keyboardBounds.size.height;
    //设置要执行动画的block
    void (^animations)(void) = ^{
        //平移TextField
        self.listView.frame = CGRectMake(0, self.originRect.origin.y, self.view.frame.size.width, self.originRect.size.height - deltaY);
    };

    if (duration > 0) {
        NSUInteger options = [[userInfo objectForKey:UIKeyboardAnimationCurveUserInfoKey] unsignedIntegerValue];
        [UIView animateWithDuration:duration delay:0 options:options animations:animations completion:nil];
    } else {
        animations();
    }
}

- (void)keyboardWillHidden:(NSNotification *)notification {
    NSDictionary *userInfo = notification.userInfo;
    //获取键盘动画的duration
    CGFloat duration = [[userInfo objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue];
    //设置要执行动画的block
    void (^animations)() = ^{
        self.listView.frame = self.originRect;
    };

    if (duration > 0) {
        NSUInteger options = [[userInfo objectForKey:UIKeyboardAnimationCurveUserInfoKey] unsignedIntegerValue];
        [UIView animateWithDuration:duration delay:0 options:options animations:animations completion:nil];
    } else {
        animations();
    }
}

#pragma mark - UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 0;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    return [UITableViewCell new];
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section {
    return CGFLOAT_MIN;
}

@end
