//
//  QGAppCoreModelClickEvent.m
//  VirtualPayment
//
//  Created by silicn on 2019/7/10.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAppCoreModelClickEvent.h"

@implementation QGAppCoreModelClickEvent

- (id)initAcmcEventWithPage:(NSString *)page_info
                       path:(NSString *)model_path
                       name:(NSString *)model_name
                detail_name:(NSString *)detail_name
           acmc_model_other:(nullable NSString *)acmc_model_other
{
    self = [self init];
    if (self) {
        self.acmc_page_info = page_info;
        self.acmc_model_path = model_path;
        self.acmc_model_name = model_name;
        self.acmc_detail_name = detail_name;
        self.acmc_model_other = acmc_model_other;
    }
    return self;
}

+ (instancetype)acmcEventWithPage:(NSString *)page_info
                             path:(NSString *)model_path
                             name:(NSString *)model_name
                      detail_name:(NSString *)detail_name
{
    QGAppCoreModelClickEvent *event = [[QGAppCoreModelClickEvent alloc]initAcmcEventWithPage:page_info path:model_path name:model_name detail_name:detail_name acmc_model_other:nil];
    return event;
}

+ (instancetype)acmcEventWithPage:(nullable NSString *)page_info
                             path:(nullable NSString *)model_path
                             name:(nullable NSString *)model_name
                      detail_name:(nullable NSString *)detail_name
                 acmc_model_other:(nullable NSString *)acmc_model_other
{
    QGAppCoreModelClickEvent *event = [[QGAppCoreModelClickEvent alloc]initAcmcEventWithPage:page_info path:model_path name:model_name detail_name:detail_name acmc_model_other:acmc_model_other];
    return event;
}


- (id)init
{
    self = [super init];
    if (self) {
        self.event = @"AppCoreModelClick";
    }
    return self;
}


@end
