//
//  QGAppCoreModelClickEvent.h
//  VirtualPayment
//
//  Created by silicn on 2019/7/10.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAppAnalyticsEvent.h"

NS_ASSUME_NONNULL_BEGIN


/**
  点击事件发生类型事件
 */
@interface QGAppCoreModelClickEvent : QGAppAnalyticsEvent

///所在页面
@property (nonatomic, copy) NSString *acmc_page_info;
///模块位置
@property (nonatomic, copy) NSString *acmc_model_path ;
///模块名称
@property (nonatomic, copy) NSString *acmc_model_name ;
///具体名称
@property (nonatomic, copy) NSString *acmc_detail_name ;
/// 其他描述
@property (nonatomic, copy) NSString *acmc_model_other;

/**
 点击事件发生类型
 VCC使用实例初始化方法
 
 特别注意：
 NSString类型的参数nil表示不包含这个字段
 
 @param  page_info    所在页面
 @param  model_path   模块位置
 @param  model_name   模块名称
 @param  detail_name  具体名称
 @return              ACMCEvent
 */
+ (instancetype)acmcEventWithPage:(nullable NSString *)page_info
                             path:(nullable NSString *)model_path
                             name:(nullable NSString *)model_name
                      detail_name:(nullable NSString *)detail_name;

/**
 点击事件发生类型
 VCC使用实例初始化方法
 
 特别注意：
 NSString类型的参数nil表示不包含这个字段
 
 @param  page_info    所在页面
 @param  model_path   模块位置
 @param  model_name   模块名称
 @param  detail_name  具体名称
 @param  acmc_model_other 其他描述
 @return              ACMCEvent
 */
+ (instancetype)acmcEventWithPage:(nullable NSString *)page_info
                             path:(nullable NSString *)model_path
                             name:(nullable NSString *)model_name
                      detail_name:(nullable NSString *)detail_name
                 acmc_model_other:(nullable NSString *)acmc_model_other;


@end

NS_ASSUME_NONNULL_END
