//
//  QGAppBusinessStateEvent.m
//  VirtualPayment
//
//  Created by silicn on 2019/7/10.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAppBusinessStateEvent.h"

@implementation QGAppBusinessStateEvent

- (id)initAbseEventWithPage:(NSString *)page_name action:(NSString *)action_name state:(NSString *)state_value code:(NSString *)state_code desc:(NSString *)state_desc phone:(NSString *)state_phone
{
    self = [self init];
    if (self) {
        self.abse_page_name = page_name;
        self.abse_action_name = action_name;
        self.abse_state_value = state_value;
        if ([state_code isKindOfClass:[NSString class]]) {
            self.abse_state_code = state_code;
        }
        if ([state_desc isKindOfClass:[NSString class]]) {
            self.abse_state_desc = state_desc;
        }
        if ([state_phone isKindOfClass:[NSString class]]) {
            self.abse_state_phone = state_phone;
        }
        
    }
    return self;
}

+ (instancetype)abseEventWithPage:(NSString *)page_name
                           action:(NSString *)action_name
                            state:(NSString *)state_value
{
    QGAppBusinessStateEvent *event = [[QGAppBusinessStateEvent alloc]initAbseEventWithPage:page_name action:action_name state:state_value code:nil desc:nil phone:nil];
    return event;
}


+ (instancetype)abseEventWithPage:(nullable NSString *)page_name
                           action:(nullable NSString *)action_name
                            value:(nullable NSString *)state_value
                             code:(nullable NSString *)state_code
                             desc:(nullable NSString *)state_desc
                            phone:(nullable NSString *)state_phone
{
    QGAppBusinessStateEvent *event = [[QGAppBusinessStateEvent alloc]initAbseEventWithPage:page_name action:action_name state:state_value code:state_code desc:state_desc phone:state_phone];
    return event;
}


- (id)init
{
    self = [super init];
    if (self) {
        self.event = @"AppBusinessStateEvent";
    }
    return self;
}


@end
