//
//  QGAnalyticsService.m
//  CreditWallet
//
//  Created by quantgroup on 2018/12/24.
//  Copyright © 2018 QuantGroup. All rights reserved.
//

#import "QGAnalyticsService.h"
#import "QGAppMacro.h"
#import "QGToolsConfig.h"
#import "QGUserInfo.h"
#import "NSString+CreditWallet.h"
//神策
#import "SensorsAnalyticsSDK.h"
//UM
#import <UMCommon/UMCommon.h>
#import <UMAnalytics/MobClick.h>

#define SA_SERVER_URL @"https://bn.xyqb.com/sa?project=production"  //正式环境地址
#define SA_SERVER_URL_Test @"https://bn.xyqb.com/sa?project=default"     //测试环境地址

@implementation QGAnalyticsService

/// 神策统计
/// @param launchOptions 入口函数 launchOptions
+(void)sensorsAnalyticsWithOptions:(NSDictionary *)launchOptions{
    
    //神策统计事件的前提
#ifdef FormalEnviroment

    ///正式环境
    SAConfigOptions *options = [[SAConfigOptions alloc]initWithServerURL:SA_SERVER_URL launchOptions:launchOptions];
    /// 设置自动采集
    options.autoTrackEventType = SensorsAnalyticsEventTypeAppStart |
                                SensorsAnalyticsEventTypeAppEnd |
                                SensorsAnalyticsEventTypeAppClick |
                                SensorsAnalyticsEventTypeAppViewScreen;
    options.maxCacheSize = 20000;
    options.enableHeatMap = YES;
    options.enableLog = NO;
    [SensorsAnalyticsSDK startWithConfigOptions:options];
    
#else
    /// 测试环境
    SAConfigOptions *options = [[SAConfigOptions alloc]initWithServerURL:SA_SERVER_URL_Test launchOptions:launchOptions];
       /// 设置自动采集
       options.autoTrackEventType = SensorsAnalyticsEventTypeAppStart |
                                   SensorsAnalyticsEventTypeAppEnd |
                                   SensorsAnalyticsEventTypeAppClick |
                                   SensorsAnalyticsEventTypeAppViewScreen;
       options.maxCacheSize = 20000;
       options.enableHeatMap = YES;
       options.enableLog = NO;
       [SensorsAnalyticsSDK startWithConfigOptions:options];
    
#endif

    //打印log
    [[SensorsAnalyticsSDK sharedInstance] enableLog:NO];

    //设置公共属性
    [[SensorsAnalyticsSDK sharedInstance] registerSuperProperties:@{@"appName": appChannel}];
    [[SensorsAnalyticsSDK sharedInstance] registerDynamicSuperProperties:^NSDictionary * _Nonnull{
        __block UIApplicationState appState;
        if (NSThread.isMainThread) {
            appState = UIApplication.sharedApplication.applicationState;
        }else {
            dispatch_sync(dispatch_get_main_queue(), ^{
                appState = UIApplication.sharedApplication.applicationState;
            });
        }
        //登录状态
        BOOL isLogin = [QGUserInfo isLogin];
        //版本号
        NSString * app_version_codeStr = [NSString stringWithFormat:@"%@",XcodeAppVersion];
        NSNumber * app_version_codeNum = @([app_version_codeStr stringByReplacingOccurrencesOfString:@"." withString:@""].integerValue);
        //公共参数
        NSDictionary * superDic = @{@"appState" : [NSNumber numberWithInteger:appState],
                                    @"isLogin" : [NSNumber numberWithBool:isLogin],
                                    @"app_channel" : appChannel,
                                    @"app_name" : @"真享花",
                                    @"app_version_code" : app_version_codeNum,
                                    @"channel_code" : registerFrom,
                                    @"os" : @"ios",
                                    @"package_name" : XcodeAppBundleIdentifier
                                    };
        return superDic;
    }];
    //H5和app 打通
    [[SensorsAnalyticsSDK sharedInstance] addWebViewUserAgentSensorsDataFlag];
    // 网络连通时发送数据
    [[SensorsAnalyticsSDK sharedInstance] setFlushNetworkPolicy:SensorsAnalyticsNetworkTypeALL];
    // CoreMotion 采集屏幕方向
    [[SensorsAnalyticsSDK sharedInstance] enableTrackScreenOrientation:YES];
}


/// 友盟统计
+ (void)umengTrack {
    NSString *identifier = [[NSBundle mainBundle] bundleIdentifier];
    NSString *umeng_appKey =[QGToolsConfig getAppKeyWithToolsType:QGToolsConfigTypeUMeng];
    //去空判断
    if (![NSString isEmpty:umeng_appKey]) {
        [UMConfigure initWithAppkey:umeng_appKey channel:identifier];
        [UMConfigure setLogEnabled:NO];   //打开log
        [UMConfigure setEncryptEnabled:YES];//打开加密传输
        [MobClick setCrashReportEnabled:NO]; //关闭bug统计
    }
    /*
    //此函数在UMCommon.framework版本1.4.2及以上版本，在UMConfigure.h的头文件中加入。
    //如果用户用组件化SDK,需要升级最新的UMCommon.framework版本。
    NSString * deviceID =[UMConfigure deviceIDForIntegration];
    NSLog(@"集成测试的deviceID:%@", deviceID);
    NSData * jsonData =[NSJSONSerialization dataWithJSONObject:@{@"oid" : deviceID}
    options: NSJSONWritingPrettyPrinted
    error: nil];
    NSLog(@"%@", [[NSString alloc] initWithData: jsonData encoding: NSUTF8StringEncoding]);
     */
}

/// 上报登录用户的UUID
/// @param loginUUID 用户登陆返回的UUID
+ (void)analyticsLoginWithUUID:(NSString *)loginUUID{
    [[SensorsAnalyticsSDK sharedInstance] login:loginUUID];
}

/// 退出登录时调用，清空用户的UUID
+ (void)analyticsLogout
{
    [[SensorsAnalyticsSDK sharedInstance] logout];
}

/// 跟踪事件
/// @param event 事件名变量
/// @param propertieDic 事件添加自定义属性
+ (void)analyticsTrack:(NSString *)event withProperties:(NSDictionary *)propertieDic{
    [[SensorsAnalyticsSDK sharedInstance] track:event
                                 withProperties:propertieDic];
}


/// 跟踪事件
/// @param eventObjc 统计事件的模型
+ (void)analyticsTrackWithEvent:(QGAppAnalyticsEvent *)eventObjc
{
    if (!eventObjc || [NSString isEmpty:eventObjc.event]) return;
    [[SensorsAnalyticsSDK sharedInstance] track:eventObjc.event
                                 withProperties:[eventObjc propertiesDictionary]];
}


@end
