//
//  QGAnalyticsService.h
//  CreditWallet
//
//  Created by quantgroup on 2018/12/24.
//  Copyright © 2018 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "QGAppAnalyticsEvent.h"
#import "QGAppCoreModelClickEvent.h"
#import "QGAppBusinessStateEvent.h"


#pragma mark - 加载统计信息类

@interface QGAnalyticsService : NSObject

/// 神策统计
/// @param launchOptions 入口函数 launchOptions
+(void)sensorsAnalyticsWithOptions:(NSDictionary *)launchOptions;


/// 友盟统计
+(void)umengTrack;


/// 上报登录用户的UUID
/// @param loginUUID 用户登陆返回的UUID
+(void)analyticsLoginWithUUID:(NSString *)loginUUID;


/// 退出登录时调用，清空用户的UUID
+ (void)analyticsLogout;


/// 跟踪事件
/// @param event 事件名变量
/// @param propertieDic 事件添加自定义属性
+(void)analyticsTrack:(NSString *)event withProperties:(NSDictionary *)propertieDic;


/// 跟踪事件
/// @param eventObjc 统计事件的模型
+(void)analyticsTrackWithEvent:(QGAppAnalyticsEvent *)eventObjc;

@end



