//
//  QGApplicationOpenURL.m
//  CreditWallet
//
//  Created by 张博 on 16/9/8.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGApplicationOpenURL.h"
#import "AppDelegate.h"
#import "SystemManager.h"
#import <UIKit/UIKit.h>
//VC
#import "CWWebViewController.h"
#import "QGUserInfo.h"

#import "QGBaseWebViewController.h"

#import "QGFaceVerifyManager.h"


@interface QGApplicationOpenURL ()
@property (nonatomic, strong) NSMutableDictionary *urlDataDic;
@property (nonatomic, strong) NSMutableDictionary *loginTypeDic;
@end

@implementation QGApplicationOpenURL
static QGApplicationOpenURL *shareInstance = nil;

/**
 *  唯一初始化方法
 */
+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareInstance = [[QGApplicationOpenURL alloc] init];
    });
    return shareInstance;
}

- (instancetype)init {
    if (self = [super init]) {
        self.urlDataDic = [self getXYQBUrlDictionary];
        self.loginTypeDic = [self getLoginTypeDictionary];
    }
    return self;
}

/**
 *  处理AppDelegate openURL需求
 *
 *  @param url 需要处理的url
 */
+ (BOOL)handleSchemeUrl:(NSURL *)url {
    return [[QGApplicationOpenURL shareInstance] handleUrl:url];
}

/**
 *  处理所有支持的URL 并执行跳转
 *
 *  @param urlStr 需要解析的URL
 *
 *  @return 返回的结果
 */
+ (BOOL)handleAllSupportUrl:(NSString *)urlStr {
    return [self handleAllSupportUrl:urlStr callbackBolck:nil];
}

/**
 处理所有支持的URL并执行跳转 带可执行回调
 
 @param urlStr 需要解析的URL
 @param callbackBolck 事件回调
 @return 是否可处理
 */
+ (BOOL)handleAllSupportUrl:(NSString *)urlStr callbackBolck:(void(^)(NSDictionary * responseDic))callbackBolck
{
    if (!urlStr) {
        return NO;
    }
    NSURL *url = [NSURL URLWithString:urlStr];
    //如果直接转失败，则编码一下 再转
    if (!url) {
        urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
        url = [NSURL URLWithString:urlStr];
    }
    return [[QGApplicationOpenURL shareInstance] handleAllSupportUrl:url callbackBolck:callbackBolck];
}


/**
 *  获取是否需要登录的字典配置
 */
- (NSMutableDictionary *)getLoginTypeDictionary {

    NSMutableDictionary *loginTypeDic = [NSMutableDictionary dictionaryWithCapacity:0];

    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeMyPersonal)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeMyHelpCenter)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeMyFeedback)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeMySetup)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeVirtualBill)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeVirtualBillMonth)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeFaceEntrance)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeCustomService)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeMsgCenter)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeFuLuMall)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeCashback)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeCreditApply)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeTransactionSettings)];
    [loginTypeDic setObject:[NSNumber numberWithBool:YES] forKey:@(XYQBJumpTypeMembershipCenter)];
    [loginTypeDic setObject:@(YES) forKey:@(XYQBJumpTypeDeposit)];
    [loginTypeDic setObject:@(YES) forKey:@(XYQBJumpTypeDepositInOut)];
    [loginTypeDic setObject:@(YES) forKey:@(XYQBJumpTypeMyFans)];
    [loginTypeDic setObject:@(YES) forKey:@(XYQBJumpTypeSharePoster)];
    [loginTypeDic setObject:@(YES) forKey:@(XYQBJumpTypeRepayment)];
    return loginTypeDic;
}

/**
 *  配置所有需要支持跳转的url
 */
- (NSMutableDictionary *)getXYQBUrlDictionary {
    //用于快速判断是否是支持的类型
    NSMutableDictionary *hostMap = [NSMutableDictionary dictionaryWithCapacity:0];
    //享花卡首页
    [hostMap setObject:@(XYQBJumpTypeCard) forKey:@"card"];
    //我的
    [hostMap setObject:@(XYQBJumpTypeMy) forKey:@"my"];
    //个人资料
    [hostMap setObject:@(XYQBJumpTypeMyPersonal) forKey:@"my/personalinfo"];
    //帮助中心
    [hostMap setObject:@(XYQBJumpTypeMyHelpCenter) forKey:@"my/helpcenter"];
    //意见反馈
    [hostMap setObject:@(XYQBJumpTypeMyFeedback) forKey:@"my/feedback"];
    //设置
    [hostMap setObject:@(XYQBJumpTypeMySetup) forKey:@"my/setup"];
    //消息中心
    [hostMap setObject:@(XYQBJumpTypeMsgCenter) forKey:@"msg-center"];
    //客服
    [hostMap setObject:@(XYQBJumpTypeCustomService) forKey:@"custom-service"];
    //我的账单
    [hostMap setObject:@(XYQBJumpTypeVirtualBill) forKey:@"virtual/bill"];
    //虚拟信用卡 月账单  BILL_TITLE_INFO=XXX&BILL_NUMBER_INFO=6  BILL_TITLE_INFO 年月，BILL_NUMBER_INFO billId
    [hostMap setObject:@(XYQBJumpTypeVirtualBillMonth) forKey:@"virtual/bill/month"];
    //活体认证 vcczxh://verify/face/entrance
    [hostMap setObject:@(XYQBJumpTypeFaceEntrance) forKey:@"verify/face/entrance"];
    //福禄跳转
    [hostMap setObject:@(XYQBJumpTypeFuLuMall) forKey:@"fulu/mall"];
    //商品详情
    [hostMap setObject:@(XYQBJumpTypeGoodsDetail) forKey:@"mall/goodsdetail"];
    //商品搜索页  mall/search?search=""
    [hostMap setObject:@(XYQBJumpTypeMallSearch) forKey:@"mall/search"];
    //搜索结果页 mall/search/result?search=""&title=""必须带search查询参数
    [hostMap setObject:@(XYQBJumpTypeMallSearchResult) forKey:@"mall/search/result"];
    // 今日热销 mall/best/seller?materialId&title
    [hostMap setObject:@(XYQBJumpTypeMallBestSeller) forKey:@"mall/best/seller"];
    //省钱tab
    [hostMap setObject:@(XYQBJumpTypeEconomical) forKey:@"economical"];
    //返现tab
    [hostMap setObject:@(XYQBJumpTypeCashback) forKey:@"cashback"];
    //信用账户额度申请
    [hostMap setObject:@(XYQBJumpTypeCreditApply) forKey:@"card/creditaccount/apply"];
    //交易设置
    [hostMap setObject:@(XYQBJumpTypeTransactionSettings) forKey:@"card/transaction/settings"];
    //存款入金
    [hostMap setObject:@(XYQBJumpTypeDeposit) forKey:@"deposit"];
    //转入转出
    [hostMap setObject:@(XYQBJumpTypeDepositInOut) forKey:@"deposit/inout"];
    //会员中心
    [hostMap setObject:@(XYQBJumpTypeMembershipCenter) forKey:@"cashback/membership/center"];
    //我的粉丝
    [hostMap setObject:@(XYQBJumpTypeMyFans) forKey:@"myfans"];
    //分享海报
    [hostMap setObject:@(XYQBJumpTypeSharePoster) forKey:@"share/poster"];
    
    [hostMap setObject:@(XYQBJumpTypeRepayment) forKey:@"payment"];
    
    return hostMap;
}

/**
 *  判断是否需要登录
 *
 *  @param jumpUrl 支持跳转的url
 *
 *  @return 返回结果
 */
- (BOOL)isNeedLoginWithJumpURL:(NSURL *)jumpUrl {
    BOOL isNeed = YES;
    XYQBJumpType result = [self autoParseURL:jumpUrl];
    NSNumber *value = [self.loginTypeDic objectForKey:@(result)];
    isNeed = value.boolValue;
    return isNeed;
}

/**
 *  解析所有的URL类型
 *
 *  @param url url
 *
 *  @return 返回 类型
 */
- (XYQBJumpType)autoParseURL:(NSURL *)url {
    XYQBJumpType result = XYQBJumpTypeUnknown;

    NSString *scheme = url.scheme;
    //判断是否是HTTP
    if ([scheme isContainOfString:@"http"]) {
        result = XYQBJumpTypeHttp;
        return result;
    } else if ([scheme isEqualToString:@"vcczxh"]) {
        //参数
        NSString *host = url.host;
        NSString *path = url.path;
        host = [host stringByAppendingString:path];
        result = [self.urlDataDic[host] intValue];
    }
    return result;
}

/**
 *  根据URL 解析出query里面的字典
 *
 *  @param url url
 *
 *  @return 返回字典
 */
- (NSDictionary *)parseQueryDicWithURL:(NSURL *)url {
    //    NSString * testStr = @"xyqb://blanknote/3c/category?id=2&title=测试测试";
    //    testStr = [testStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    //    url = [NSURL URLWithString:testStr];

    //移除encode编码
    NSString *queryString = [url.query stringByRemovingPercentEncoding];
    NSMutableDictionary *dataDic = [NSMutableDictionary dictionaryWithCapacity:0];

    NSArray *subArray = [queryString componentsSeparatedByString:@"&"];
    for (NSString *subString in subArray) {
        NSArray *dicArray = [subString componentsSeparatedByString:@"="];
        if (dicArray.count == 2) {
            NSString *key = dicArray[0];
            NSString *value = dicArray[1];

            //如果值出现问题，过滤一下
            if (value.length == 0) {
                value = @"";
            }
            //如果key出现问题，则把数据丢弃
            if (key.length == 0) {
                continue;
            }

            [dataDic setObject:value forKey:key];
        } else {
            NSLog(@"queryString有问题，请查看");
        }
    }

    return dataDic;
}

/**
 *  处理所有支持的URL 并执行跳转
 *
 *  @param url 需要解析的URL
 *
 *  @return 返回的结果
 */
- (BOOL)handleAllSupportUrl:(NSURL *)url callbackBolck:(void(^)(NSDictionary * responseDic))callbackBolck {
    BOOL result = YES;

    XYQBJumpType hostValue = [self autoParseURL:url];
    if (hostValue == XYQBJumpTypeUnknown) {
        [QGHUDManager showHud:@"版本过低，不支持此功能"];
        return NO;
    }

    [self jumpManagerWithUrl:url jumpType:hostValue callbackBolck:callbackBolck];

    return result;
}

/**
 *  处理AppDelegate openURL需求 只能解析xyqb开头的
 *
 *  @param url 需要处理的url
 */
- (BOOL)handleUrl:(NSURL *)url {
    BOOL result = YES;
    //信用钱包开头  xyqb
    NSString *scheme = url.scheme;
    //开头不合法 直接返回
    if (![scheme isEqualToString:@"vcczxh"]) {
        result = NO;
        return result;
    }

    XYQBJumpType hostValue = [self autoParseURL:url];
    if (hostValue == XYQBJumpTypeUnknown) {
        [QGHUDManager showHud:@"版本过低，不支持此功能"];
        return NO;
    }

    [self jumpManagerWithUrl:url jumpType:hostValue callbackBolck:nil];

    return YES;
}

- (void)jumpManagerWithUrl:(NSURL *)url jumpType:(XYQBJumpType)hostValue callbackBolck:(void(^)(NSDictionary * responseDic))callbackBolck {
    UINavigationController *currentNav = [SystemManager shareInstance].currentNav;
    //特殊情况下触发，概率非常小，规避问题处理
    if (!currentNav) {
        return;
    }

    //如果没有登录 并且该页面需要登录
    if ([QGUserInfo isLogin] == NO && [self isNeedLoginWithJumpURL:url]) {
        __weak typeof(self) weakSelf = self;
        
        [currentNav.topViewController showLoginViewControllerCompletion:^{
            [weakSelf jumpManagerWithUrl:url jumpType:hostValue callbackBolck:callbackBolck];
        }];
        return;
    }

    //参数
    NSDictionary *queryDic = [self parseQueryDicWithURL:url];
    
    //HTTP
    if (hostValue == XYQBJumpTypeHttp) {
        [self jumpWebViewWithUrl:url];
    }
    //借款首页
    else if (hostValue == XYQBJumpTypeCard) {
        [self jumpCardHomePage];
    }
    //我的
    else if (hostValue == XYQBJumpTypeMy) {
        [self jumpMyHomePage];
    }
    //消息中心
    else if (hostValue == XYQBJumpTypeMsgCenter) {
    
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageCenterVC] parameters:nil handlerBlock:nil];
    }
    //打开客服
    else if (hostValue == XYQBJumpTypeCustomService) {
        [self jumpCustomService];
    }
    //设置
    else if (hostValue == XYQBJumpTypeMySetup)
    {
        [self jumpMySetup];
    }
    //意见反馈
    else if (hostValue == XYQBJumpTypeMyFeedback)
    {
        [self jumpMyFeedback];
    }
    //帮助中心
    else if (hostValue == XYQBJumpTypeMyHelpCenter)
    {
        [self jumpMyHelpCenter];
    }
    //个人资料
    else if (hostValue == XYQBJumpTypeMyPersonal)
    {
        [self jumpMyPersonal];
    }
    //虚拟信用卡我的账单
    else if (hostValue == XYQBJumpTypeVirtualBill)
    {
        [self JumpTypeVirtualBill];
    }
    //虚拟信用卡月账单
    else if (hostValue == XYQBJumpTypeVirtualBillMonth)
    {
        [self jumpTypeVirtualBillMonthWithDic:queryDic];
    }
    //活体识别
    else if (hostValue == XYQBJumpTypeFaceEntrance)
    {
        [self jumpTypeFaceEntranceWithCallbackBolck:callbackBolck];
    }
    //福禄
    else if (hostValue == XYQBJumpTypeFuLuMall)
    {
        [self jumpFuLuWebView];
    }
    // 搜索页
    else if (hostValue == XYQBJumpTypeMallSearch)
    {
        [self jumpMallSearchWithDic:queryDic];
    }
    // 搜索结果页面
    else if (hostValue == XYQBJumpTypeMallSearchResult)
    {
        [self jumpMallSearchReultWithDic:queryDic];
    }
    //商品详情
    else if (hostValue == XYQBJumpTypeGoodsDetail)
    {
        [self jumpGoodsDetail:queryDic];
    }
    //今日热销
    else if (hostValue == XYQBJumpTypeMallBestSeller)
    {
        [self jumpBestSeller:queryDic];
    }
    //省钱
    else if (hostValue == XYQBJumpTypeEconomical)
    {
        [self jumpMall];
    }
    //返现
    else if (hostValue == XYQBJumpTypeCashback)
    {
        [self jumpCashback];
    }
    //额度申请页
    else if (hostValue == XYQBJumpTypeCreditApply)
    {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGCreditApplyViewController) parameters:nil handlerBlock:nil];
    }
    //交易设置
    else if (hostValue == XYQBJumpTypeTransactionSettings)
    {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGTransactionSetController) parameters:nil handlerBlock:nil];
    }
    // 存款入金
    else if (hostValue == XYQBJumpTypeDeposit)
    {
        [self jumpDeposit];
    }
    // 转入转出
    else if (hostValue == XYQBJumpTypeDepositInOut)
    {
        [self jumpDepositInOut:queryDic];
    }
    else if (hostValue == XYQBJumpTypeMembershipCenter)
    {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMembershipCenterViewController) parameters:nil handlerBlock:nil];
    }else if (hostValue == XYQBJumpTypeMyFans){
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGFansContainerViewController) parameters:nil handlerBlock:NULL];
    }else if (hostValue == XYQBJumpTypeSharePoster){
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGSharePosterViewController) parameters:nil handlerBlock:NULL];
    }else if (hostValue == XYQBJumpTypeRepayment){
        [self jumpRepayment:queryDic];
    }
    else {
        [QGHUDManager showHud:@"版本过低，不支持此功能" afterDelay:1];
    }
    
}


#pragma mark - 享花卡首页
- (void)jumpCardHomePage
{
    [[SystemManager shareInstance].currentNav popToRootViewControllerAnimated:NO];
    [[SystemManager shareInstance].tabbarController jumpCard];
}

#pragma mark - 省钱
- (void)jumpMall
{
    [[SystemManager shareInstance].currentNav popToRootViewControllerAnimated:NO];
    [[SystemManager shareInstance].tabbarController jumpMall];
}


#pragma mark - 返现
- (void)jumpCashback
{
    [[SystemManager shareInstance].currentNav popToRootViewControllerAnimated:NO];
    [[SystemManager shareInstance].tabbarController jumpCashback];
}


#pragma mark - 我的首页
- (void)jumpMyHomePage
{
    [[SystemManager shareInstance].currentNav popToRootViewControllerAnimated:NO];
    [[SystemManager shareInstance].tabbarController jumpMy];
}


#pragma mark - 网页
- (void)jumpWebViewWithUrl:(NSURL *)url {
    CWWebViewController *webVC = [[CWWebViewController alloc] init];
    webVC.urlString = url.absoluteString;
    [[SystemManager shareInstance].currentNav pushViewController:webVC animated:YES];
}

#pragma mark - 在线客服
- (void)jumpCustomService {
    CWWebViewController *vc = [[CWWebViewController alloc] init];
    vc.title = @"客服";
    NSString *urlStr = VCCServiceUrl;
    vc.urlString = urlStr;
    [[SystemManager shareInstance].currentNav pushViewController:vc animated:YES];
}


#pragma mark - 活体识别
- (void)jumpTypeFaceEntranceWithCallbackBolck:(void(^)(NSDictionary * responseDic))callbackBolck
{
    
    [QGFaceVerifyManager.shareInstance openFaceVerifySuccess:^{
        if (callbackBolck) callbackBolck(nil);
    }];
    
//    [[SystemManager shareInstance].currentViewController openfaceIDMegLiveStill];
//    //把活体的结果传出去
//    if (callbackBolck) {
//        [SystemManager shareInstance].currentViewController.megliveSuccessBlock = ^(NSDictionary * _Nonnull successDic) {
//            callbackBolck(successDic);
//        };
//    }
}

#pragma mark - 虚拟信用卡我的账单
- (void)JumpTypeVirtualBill
{
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGRepaymentGroupViewController] parameters:nil handlerBlock:NULL];
}

#pragma mark - 虚拟信用卡月账单
- (void)jumpTypeVirtualBillMonthWithDic:(NSDictionary *)dic
{
    NSString *billNo = dic[@"BILL_NUMBER_INFO"];
    if ([NSString isEmpty:billNo]) return;
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
     [param setObject:billNo forKey:@"billId"];
    if (dic[@"BILL_TITLE_INFO"]) {
        [param setObject:dic[@"BILL_TITLE_INFO"] forKey:@"yearMonth"];
    }
    [param setObject:@(YES) forKey:@"shouldExtInsets"];
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGRepaymentViewController) parameters:param handlerBlock:NULL];
}


/// 跳转设置
- (void)jumpMySetup
{
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMineSetCenterViewController] parameters:nil handlerBlock:nil];
}


/// 跳转意见反馈
- (void)jumpMyFeedback
{
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGFeedbackViewController] parameters:nil handlerBlock:nil];
}

/// 帮助中心
- (void)jumpMyHelpCenter
{
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGHelpCenterViewController] parameters:nil handlerBlock:nil];
}
//个人资料
- (void)jumpMyPersonal
{
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMinePersonalDataViewController] parameters:nil handlerBlock:nil];
}
//跳转到福禄
- (void)jumpFuLuWebView
{
    /* 因为是测试环境，所以需要屏蔽福禄 2.0.00 开放
    NSString * urlString = [NSString stringWithFormat:@"https://cmbcitmall.suuyuu.cn?codeid=f2wdbgXK&uuid=%@",[QGUserInfo sharedUserInfo].uuid];
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGFuLuWebViewController) parameters:@{@"urlString":urlString} handlerBlock:nil];
     */
}

- (void)jumpMallSearchWithDic:(NSDictionary *)dic
{
    NSString *searchText = dic[@"search"];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    if (searchText) {
        [param setObject:searchText forKey:@"searchText"];
    }
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGSearchMallViewController) isPush:NO animation:NO parameters:param handlerBlock:NULL];
}

/// 跳转商品搜索结果页
- (void)jumpMallSearchReultWithDic:(NSDictionary *)dic
{
    NSString *searchText = dic[@"search"];
    if ([NSString isEmpty:searchText]) return;
    
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setObject:searchText forKey:@"searchText"];
    
    NSString *title = dic[@"title"];
    if (title) {
        [param setObject:title forKey:@"title"];
    }
    [param setObject:@(YES) forKey:@"hiddenSearchBar"];
    
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGSearchMallResultViewController] isPush:YES  parameters:param handlerBlock:NULL];
}
/// 跳转今日热销
- (void)jumpBestSeller:(NSDictionary *)dic
{
    NSString *materialId = dic[@"materialId"];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    if (materialId) {
        [param setObject:materialId forKey:@"materialId"];
    }
    NSString *title = dic[@"title"];
    if (title) {
        [param setObject:title forKey:@"title"];
    }
     [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGBestSellersViewController] isPush:YES  parameters:param handlerBlock:NULL];
}

//商品详情
- (void)jumpGoodsDetail:(NSDictionary *)param
{
    //获取商品id
    NSString * goodsId = [NSString stringWithFormat:@"%@",param[@"goodsId"]];
    if (![NSString isEmpty:goodsId]) {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallGoodsDetailViewController) parameters:@{@"goodsId":goodsId} handlerBlock:nil];
    }
}

//存款入金

- (void)jumpDeposit
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGDepositViewController) parameters:nil handlerBlock:NULL];
}

- (void)jumpDepositInOut:(NSDictionary *)param
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGDepositeRecordedViewController) parameters:param handlerBlock:NULL];
}

// 还款页面
- (void)jumpRepayment:(NSDictionary *)param
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGRepaymentCommitViewController) parameters:param handlerBlock:NULL];
}

@end
