//
//  QGApplicationOpenURL.h
//  CreditWallet
//
//  Created by 张博 on 16/9/8.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef enum : NSUInteger {
    XYQBJumpTypeUnknown = 0,                //未知
    XYQBJumpTypeHttp,                       //http格式，需要跳转web页面
    XYQBJumpTypeCard,                       //借款首页
    XYQBJumpTypeMy,                         //我的首页
    XYQBJumpTypeEconomical,                 //省钱tab
    XYQBJumpTypeCashback,                   //返现tab
    XYQBJumpTypeMsgCenter,                  //消息中心
    XYQBJumpTypeCustomService,              //客服
    XYQBJumpTypeVirtualBill,                //虚拟信用卡我的账单
    XYQBJumpTypeVirtualBillMonth,           //虚拟信用卡月账单
    XYQBJumpTypeFaceEntrance,               //face++活体识别
    XYQBJumpTypeMyPersonal,                 //个人资料
    XYQBJumpTypeMyHelpCenter,               //帮助中心
    XYQBJumpTypeMyFeedback,                 //用户反馈
    XYQBJumpTypeMySetup,                    //设置
    XYQBJumpTypeFuLuMall,                   //福禄商城
    XYQBJumpTypeGoodsDetail,                //商品详情
    XYQBJumpTypeMallSearch,                 //商品搜索页
    XYQBJumpTypeMallSearchResult,           //搜索结果页面
    XYQBJumpTypeMallBestSeller,             //今日热销
    XYQBJumpTypeCreditApply,                //信用账户额度申请
    XYQBJumpTypeTransactionSettings,        //交易设置
    XYQBJumpTypeDeposit,                    //存款入金
    XYQBJumpTypeDepositInOut,               //转入转出
    XYQBJumpTypeMembershipCenter,           //会员中心
    XYQBJumpTypeMyFans,                     //我的粉丝
    XYQBJumpTypeSharePoster,                //分享海报
    XYQBJumpTypeRepayment,                  //还款页面
} XYQBJumpType;

/**
 *  本类处理推送跳转、webView跳转、外部应用跳转页面
 */
@interface QGApplicationOpenURL : NSObject

/**
 *  唯一初始化方法
 */
+ (instancetype)shareInstance;

/**
 *  处理AppDelegate openURL需求
 *
 *  @param url 需要处理的url
 */
+ (BOOL)handleSchemeUrl:(NSURL *)url;

/**
 *  处理所有支持的URL并执行跳转
 *
 *  @param urlStr 需要解析的URL
 *
 *  @return 返回的结果
 */
+ (BOOL)handleAllSupportUrl:(NSString *)urlStr;


/**
 处理所有支持的URL并执行跳转 带可执行回调

 @param urlStr 需要解析的URL
 @param callbackBolck 事件回调
 @return 是否可处理
 */
+ (BOOL)handleAllSupportUrl:(NSString *)urlStr callbackBolck:(void(^)(NSDictionary * responseDic))callbackBolck;

/**
 *  解析所有的URL类型
 *
 *  @param url url
 *
 *  @return 返回 类型
 */
- (XYQBJumpType)autoParseURL:(NSURL *)url;

/**
 *  根据URL 解析出query里面的字典
 *
 *  @param url url
 *
 *  @return 返回字典
 */
- (NSDictionary *)parseQueryDicWithURL:(NSURL *)url;

/**
 *  判断是否需要登录
 *
 *  @param jumpUrl 支持跳转的url
 *
 *  @return 返回结果
 */
- (BOOL)isNeedLoginWithJumpURL:(NSURL *)jumpUrl;
@end
