//
//  QGCalendarModel.h
//  CreditWallet
//
//  Created by 张博 on 16/10/19.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface QGCalendarMonthModel : NSObject

@property (nonatomic, strong) NSString * year;
@property (nonatomic, strong) NSString * month;
/**
 *  数据源数组
 */
@property (nonatomic, strong) NSMutableArray * dayArray;
/**
 *  每月第一天开始的位置
 */
@property (nonatomic, assign) NSInteger beginIndex;
/**
 *  一月的周数
 */
@property (nonatomic, assign) NSInteger weeksNum;
/**
 *  一月的天数
 */
@property (nonatomic, assign) NSInteger daysNum;


@end



typedef enum : NSUInteger {
    CalendarDayStyleNomal,  //默认状态，可点击
    CalendarDayStyleUnusable, //不可选
    CalendarDayStyleToday,    //今天
    CalendarDayStyleReservation, //预售
} CalendarDayStyle;


@interface QGCalendarDayModel : NSObject

/**
 *  日期
 */
@property (nonatomic, strong) NSDate * date;
/**
 *  年
 */
@property (nonatomic, strong) NSString * year;
/**
 *  月
 */
@property (nonatomic, strong) NSString * month;
/**
 *  日
 */
@property (nonatomic, strong) NSString * day;

/**
 *  阴历日
 */
@property (nonatomic, strong) NSString * lunarDay;

/**
 *  日历的样式
 */
@property (nonatomic, assign) CalendarDayStyle dayStyle;

///**
// *  是否不可选
// */
//@property (nonatomic, assign) BOOL isUnusable;
//
///**
// *  是否是今日
// */
//@property (nonatomic, assign) BOOL isToday;
//
/**
 *  是否被选中
 */
@property (nonatomic, assign) BOOL isSelect;
@end