//
//  AccessPermissionsManager.m
//  CreditWallet
//
//  Created by 张博 on 17/3/10.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "AccessPermissionsManager.h"
#import <UIKit/UIKit.h>

//相册权限
#import<AssetsLibrary/AssetsLibrary.h>
#import <Photos/Photos.h>
//相机权限
#import<AVFoundation/AVCaptureDevice.h>
#import<AVFoundation/AVMediaFormat.h>
//通讯录权限
#import <AddressBook/AddressBook.h>
#import "QGAppMacro.h"

#import "QGAlertView.h"


@implementation AccessPermissionsManager

#pragma mark - 相册

- (void)requestCameraAuthorization:(void (^)(void))successCallback {
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
        AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeVideo];
        if (authStatus == AVAuthorizationStatusNotDetermined) {
            __weak typeof(self) weakSelf = self;
            [AVCaptureDevice requestAccessForMediaType:AVMediaTypeVideo completionHandler:^(BOOL granted) {
                //防止卡顿
                dispatch_async(dispatch_get_main_queue(), ^{
                    __strong typeof(weakSelf)strongSelf = self;
                    //同意
                    if (granted) {
                        if (successCallback) {
                            successCallback();
                        }
                    } else
                    {
                        [strongSelf askCameraAlert];
                    }
                });
            }];
        }
        //允许
        else if (authStatus == AVAuthorizationStatusAuthorized) {
            if (successCallback) {
                successCallback();
            }
        }
        //没权限
        else if (authStatus == AVAuthorizationStatusDenied) {
            [self askCameraAlert];
        }
        //系统受限制操作
        else if (authStatus == AVAuthorizationStatusRestricted) {
            [self askCameraAlert];
        }
    } else {
        
    }
}

///请求访问相机弹出的alert
- (void)askCameraAlert
{
    QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"提示" message:@"请在设备的\"设置-隐私-相机\"中允许访问相机。" cancelButtonTitle:@"取消" sureButtonTitle:@"设置" clickBlock:^(NSInteger index) {
        if (index == 1) {
           NSURL *url = [NSURL URLWithString:UIApplicationOpenSettingsURLString];
            if([[UIApplication sharedApplication]canOpenURL:url]) {
                if (@available(iOS 10.0, *)) {
                    [[UIApplication sharedApplication] openURL:url options:@{} completionHandler:nil];
                } else {
                    [[UIApplication sharedApplication] openURL:url];
                    // Fallback on earlier versions
                }
            }
        }
    }];
    [alert showInView:nil];
  
}

///读取通讯录权限
- (BOOL)checkAddressBookAuthorizationStatus
{
    CFErrorRef *error = nil;
    ABAddressBookRef addressBook = ABAddressBookCreateWithOptions(NULL, error);
    __block BOOL accessGranted = NO;
    if (&ABAddressBookRequestAccessWithCompletion) { // we're on iOS 6
        dispatch_semaphore_t sema = dispatch_semaphore_create(0);
        ABAddressBookRequestAccessWithCompletion(addressBook, ^(bool granted, CFErrorRef error) {
            accessGranted = granted;
            dispatch_semaphore_signal(sema);
        });
        dispatch_semaphore_wait(sema, DISPATCH_TIME_FOREVER);
        
    }
    if (addressBook)
    {
        CFRelease(addressBook);
        addressBook = NULL;
    }
    return accessGranted;
}


///检测通讯录权限，展示UI
- (BOOL)checkAddressBook
{
    if (![self checkAddressBookAuthorizationStatus]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"提示" message:@"为了更好的体验功能，请到设置 -> 真享生活，将通讯录对应的开关开启" cancelButtonTitle:@"取消" sureButtonTitle:@"开启" clickBlock:^(NSInteger index) {
                   if (index == 1) {
                      NSURL *url = [NSURL URLWithString:UIApplicationOpenSettingsURLString];
                       if([[UIApplication sharedApplication]canOpenURL:url]) {
                           if (@available(iOS 10.0, *)) {
                               [[UIApplication sharedApplication] openURL:url options:@{} completionHandler:nil];
                           } else {
                               [[UIApplication sharedApplication] openURL:url];
                               // Fallback on earlier versions
                           }
                       }
                   }
               }];
               [alert showInView:nil];
            
        });
        
        return NO;
    }
    return YES;
}



- (void)saveImg
{
//    [[PHPhotoLibrary sharedPhotoLibrary] performChanges:^{
//         PHAssetChangeRequest *req = [PHAssetChangeRequest creationRequestForAssetFromImage:image];
//     } completionHandler:^(BOOL success, NSError * _Nullable error) {
//         NSLog(@"success = %d, error = %@", success, error);
//    }];
}



@end
