//
//  BaseModel.m
//  CreditWallet
//
//  Created by 张博 on 16/8/25.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "BaseModel.h"
#import <objc/runtime.h>
@implementation BaseModel

-(id)initWithDic:(NSDictionary *)dic
{
    if (self = [super init])
    {
        if ([dic isKindOfClass:[NSDictionary class]]) {
            [RMMapper populateObject:self fromDictionary:dic];
            self.myDataDic  = dic;
        }
    }
    return self;
}

#pragma mark - RM代理方法  子类特殊处理时需要重写
- (NSDictionary *)rm_dataKeysForClassProperties
{
    //把不符合OC的属性转换一下，在这里例如外面使用的是 infoId  字典里面是id  那么此处应该 @{@"infoId":@"id"}
    return @{@"pageId":@"id"};
}

//把子类不需要自动解析的属性添加进来
- (NSArray *)rm_excludedProperties;
{
    return @[];
}

// Parse item within array
- (Class)rm_itemClassForArrayProperty:(NSString*)property;
{
    //如果数组listArray里面存放实体A  此处判断  “property == listArray” return [A class]
    return nil;
}

-(NSString *)description
{
    NSMutableDictionary * props = [NSMutableDictionary dictionary];
    unsigned int outCount;
    objc_property_t * properties = class_copyPropertyList([self class], &outCount);
    for (int i = 0; i<outCount; i++) {
        objc_property_t  property = properties[i];
        const char * chat_f = property_getName(property);
        NSString * propertyName = [NSString stringWithUTF8String:chat_f];
        id propertyValue = [self valueForKey:(NSString *)propertyName];
        
        if (propertyValue) {
            [props setObject:propertyValue forKey:propertyName];
        }
        
        //        free(properties);
    }
    
    NSString * showStr = @"";
    for (NSString * key in props.allKeys) {
        NSString * valueStr = props[key];
        showStr = [showStr stringByAppendingFormat:@"%@:%@  ",key,valueStr];
    }
    return showStr;
}


- (NSDictionary *)myDataDic
{
    //如果字典里面没有值，则置空
    if (_myDataDic.allKeys.count == 0) {
        _myDataDic = nil;
    }
    return _myDataDic;
}


@end
