//
//  QGTableViewCommonCell.m
//  VirtualPayment
//
//  Created by 胡红磊 on 2019/6/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGTableViewCommonCell.h"
#import "QGBasicUITool.h"

@interface QGTableViewCommonCell ()

/**
 分割线
 */
@property (nonatomic, strong) UIView  *separatorLine;

/**
 右侧图标
 */
@property (nonatomic, strong, readwrite) UIImageView *arrowImage;

@end

@implementation QGTableViewCommonCell

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //右侧图片
        self.arrowImage = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"cell_right_arrow"];
        self.arrowImage.contentMode =  UIViewContentModeCenter;
        [self.arrowImage mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(self.contentView.mas_centerY);
            make.right.mas_equalTo(self.contentView.mas_right).offset(-20);
        }];
        
        
        //分割线
        self.separatorLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [self.separatorLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.contentView.mas_bottom).offset(-0.5);
            make.height.mas_equalTo(0.5);
        }];
        
    }
    return self;
}

- (void)setArrowHide:(BOOL)arrowHide
{
    _arrowHide = arrowHide;
    self.arrowImage.hidden = arrowHide;
}

-(void)setPadding:(CGFloat)padding
{
    if (_padding != padding) {
        _padding = padding;
        
        //更新分割线约束
        [self.separatorLine mas_updateConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(self.padding);
        }];
        
        [self.arrowImage mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(self.contentView.mas_right).offset(-self.padding);
        }];
        
    }
}

-(void)setSeparateLineHide:(BOOL)separateLineHide
{
    _separateLineHide = separateLineHide;
    _separatorLine.hidden = separateLineHide;
    
}

+ (instancetype)initWithTableView:(UITableView *)tableView
{
    NSAssert(1, @"Method:\"initWithTableView\" not implementation");
    return nil;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    // Configure the view for the selected state
}

@end
