//
//  QGPasteboardLabel.m
//  VirtualPayment
//
//  Created by 张博 on 2019/8/15.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGPasteboardLabel.h"
#import "QGHUDManager.h"
@implementation QGPasteboardLabel

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.userInteractionEnabled = YES;
        [self addGestureRecognizer:[[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)]];
    }
    return self;
}


- (void)longPress:(UIGestureRecognizer *)gesture {
    if (gesture.state == UIGestureRecognizerStateBegan) {
        // 设置label为第一响应者
        [self becomeFirstResponder];
        // 自定义 UIMenuController
        UIMenuController * menu = [UIMenuController sharedMenuController];
        UIMenuItem * item1 = [[UIMenuItem alloc]initWithTitle:@"复制" action:@selector(copyText:)];
        menu.menuItems = @[item1];
        [menu setTargetRect:self.bounds inView:self];
        [menu setMenuVisible:YES animated:YES];
    }
}


- (BOOL)canBecomeFirstResponder {
    return YES;
}

- (BOOL)canPerformAction:(SEL)action withSender:(id)sender {
    if(action == @selector(copyText:)) return YES;
    return NO;
}

- (void)copyText:(UIMenuController *)menu {
    // 没有文字时结束方法
    if (!self.text) return;
    // 复制文字到剪切板
    UIPasteboard * paste = [UIPasteboard generalPasteboard];
    
    if (self.isClearWhitespace) {
        NSString * resultText = [self.text stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
        resultText = [resultText stringByReplacingOccurrencesOfString:@" " withString:@""];
        paste.string = resultText;
        paste.strings = @[resultText];
    }
    else
    {
        paste.string = self.text;
        paste.strings = @[self.text];
    }
    
    
    [QGHUDManager showHud:@"复制成功"];

}


@end
