//
//  QGMarqueeView.h
//  VirtualPayment
//
//  Created by silicn on 2019/5/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,QGMarqueeScrollDirection)
{
    QGMarqueeScrollDirectionBTT = 0, /// bottom to top
    QGMarqueeScrollDirectionTTB      /// top to bottom
};

typedef void(^QGMarqueeViewClickBlock)(NSInteger selectIndex);

// 跑马灯效果Label
@interface QGMarqueeView : UIView

/// 文本数组 多条数据上下左右滑动
@property (nonatomic, copy)NSArray<NSString *> *textArray;

/// 字体颜色
@property (nonatomic, strong)UIColor *textColor;

///字体Font Default SystemFontSize:15.0f
@property (nonatomic, strong)UIFont *font;

/// 滚动方向  默认QGMarqueeScrollDirectionTTB 从上到下
@property (nonatomic, assign)QGMarqueeScrollDirection scrollDirection;

/// 点击消息触发的回调
@property (nonatomic, copy) QGMarqueeViewClickBlock clickEventBlock;

/// 是否隐藏右侧箭头
@property (nonatomic, assign)BOOL hiddenIndicator;

@end

NS_ASSUME_NONNULL_END
