//
//  QGInputGroupView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/14.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGInputGroupView.h"
#import "QGBasicUITool.h"

#import "Masonry.h"


@interface QGInputGroupView()
{
    NSString *_text;
}

@property (nonatomic, strong)UILabel *titleLab;

@property (nonatomic, strong)UITextField *textField;

@property (nonatomic, copy)NSString *placeHolder;
///是否隐藏密码
@property (nonatomic, assign)BOOL encryptPwd;


@end



@implementation QGInputGroupView


- (instancetype)init
{
    self  = [super init];
    if (self) {
        self.encryptPwd = YES;
    }
    return self;
}


- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setUps];
    }
    return self;
}

- (void)setUps
{
    self.titleLab = [UILabel creatLabelWithSuperView:self title:self.title titleFontSize:[UIFont qg_regularFontOfSize:10.0f] textColor:[UIColor textColor6666] alignment:NSTextAlignmentLeft];
    [_titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.mas_topMargin).inset(-8);
        }
        make.right.lessThanOrEqualTo(self);
    }];
    
    self.textField = [UITextField creatTextFieldWithSuperView:self placeholder:nil titleFontSize:[UIFont qg_regularFontOfSize:18.0f] textColor:[UIColor textColor3333] tintColor:nil clearButtonMode:UITextFieldViewModeWhileEditing];
    _textField.textAlignment = NSTextAlignmentLeft;
    self.textField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
    self.textField.autocorrectionType = UITextAutocorrectionTypeNo;
//    _textField.backgroundColor = [UIColor redColor];
    //设置清除样式
    UIButton *clearBtn = [_textField valueForKey:@"_clearButton"];
    [clearBtn setImage:[UIImage imageNamed:@"input_delete"] forState:UIControlStateNormal];
    [clearBtn setImage:[UIImage imageNamed:@"input_delete"] forState:UIControlStateHighlighted];
    
    self.accessoryButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self addSubview:_accessoryButton];
    [_accessoryButton addTarget:self action:@selector(rightAction:) forControlEvents:UIControlEventTouchUpInside];
//    _accessoryButton.backgroundColor = [UIColor cyanColor];
    [self.accessoryButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.textField.mas_centerY);
        make.right.equalTo(self);
        make.height.equalTo(@(30));
        make.height.equalTo(@(30));
    }];
    
    
}

- (instancetype)initWithType:(InputViewType)type
                       title:(NSString *)title
                 placeHolder:(NSString *)placholder
{
    self = [super init];
    if (self) {
        self.title = title;
        [self updateTextFieldConstraints];
        self.type = type;
        self.placeHolder = placholder;
    }
    return self;
}

/*
 是否包含title
 */
- (void)updateTextFieldConstraints
{
    if (!self.title) {  //不包含title
        self.titleLab.hidden = YES;
        [self.textField mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self);
            if (@available(iOS 11.0, *)) {
                make.top.equalTo(self.mas_safeAreaLayoutGuideTop);
            } else {
                make.top.equalTo(self.mas_topMargin).inset(-8);
            }
            make.bottom.equalTo(self);
            make.right.equalTo(self.accessoryButton.mas_left);
        }];
    }else{  // 包含title
        self.titleLab.hidden = NO;
        [_textField mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.titleLab);
            make.top.equalTo(self.titleLab.mas_bottom).offset(8);
            make.bottom.equalTo(self);
            make.right.equalTo(self.accessoryButton.mas_left);
        }];
    }
}

/**
 accessoryButton 点击方法

 @param btn  accessoryButton
 */
- (void)rightAction:(UIButton *)btn
{
    if (self.type == InputViewTypePwd) {
         self.encryptPwd = !self.encryptPwd;
    }else{
        if (self.accessoryBlock) {self.accessoryBlock();}
    }
}


- (void)setTitle:(NSString *)title
{
    _title = title;
    self.titleLab.text = title;
}

- (void)setTitleColor:(UIColor *)titleColor
{
    _titleColor = titleColor;
    self.titleLab.textColor = titleColor;
}

#pragma - mark  设置样式
- (void)setType:(InputViewType)type
{
    _type = type;
    if (type == InputViewTypePwd) {
        self.encryptPwd = YES;
        [self.accessoryButton setImage:[UIImage imageNamed:@"input_encryption"] forState:UIControlStateNormal];
        self.textField.clearButtonMode = UITextFieldViewModeNever;
        [self.accessoryButton mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(30);
        }];
    }else if (type == InputViewTypeTextHint){
        [self.accessoryButton setImage:[UIImage imageNamed:@"input_hint"] forState:UIControlStateNormal];
        [self.accessoryButton mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
        }];
    }else if (type == InputViewTypeCustom){
        self.accessoryButton.hidden = NO;
        [self.accessoryButton mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
        }];
    }else{
        [self.accessoryButton mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(0);
        }];
    }
}

/**
 添加右边视图，设置约束

 @param accessoryView 右配件视图
 */
- (void)setAccessoryView:(UIView *)accessoryView
{
    if (_accessoryView) {
        [_accessoryView removeFromSuperview];
    }
    self.accessoryButton.hidden = YES;
    _accessoryView = accessoryView;
    if (accessoryView) {
        [self addSubview:accessoryView];
        [accessoryView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(self.textField.mas_centerY);
            make.right.equalTo(self);
            make.height.greaterThanOrEqualTo(self.textField.mas_height);
        }];
        [self changeTextFieldConstrainsWithAccessoryView:accessoryView];
    }
}


/**
 重新设置TextField的右边约束

 @param accessoryView TextField依赖的右配件
 */
- (void)changeTextFieldConstrainsWithAccessoryView:(UIView *)accessoryView
{
    if (!self.title) {  //不包含title
        [self.textField mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self);
            if (@available(iOS 11.0, *)) {
                make.top.equalTo(self.mas_safeAreaLayoutGuideTop);
            } else {
                make.top.equalTo(self.mas_topMargin).inset(-8);
            }
            make.bottom.equalTo(self);
            make.right.equalTo(accessoryView.mas_left);
        }];
    }else{  // 包含title
        self.titleLab.hidden = NO;
        [_textField mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.titleLab);
            make.top.equalTo(self.titleLab.mas_bottom).offset(8);
            make.bottom.equalTo(self);
            make.right.equalTo(accessoryView.mas_left);
        }];
    }
}


- (void)setEncryptPwd:(BOOL)encryptPwd
{
    _encryptPwd = encryptPwd;
    if (encryptPwd) {
        [self.accessoryButton setImage:[UIImage imageNamed:@"input_encryption"] forState:UIControlStateNormal];
    }else{
        [self.accessoryButton setImage:[UIImage imageNamed:@"input_open"] forState:UIControlStateNormal];
    }
    self.textField.secureTextEntry = encryptPwd;
}

- (void)setPlaceHolder:(NSString *)placeHolder
{
    _placeHolder = placeHolder;
    self.textField.placeholder = placeHolder;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
