//
//  QGGradientShadowButton.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/10.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGGradientShadowButton.h"
#import "UIColor+QGColor.h"
@interface QGGradientShadowButton ()

/**
 渐变色图层
 */
@property (nonatomic, strong, readwrite) CAGradientLayer * gradientLayer;

@end


@implementation QGGradientShadowButton

/**
 创建渐变色按钮
 
 @param title 标题
 @param textFont 字号
 @return 按钮实例
 */
+ (QGGradientShadowButton *)creatGradientColorButtonWithSuperView:(UIView *)superView title:(nullable NSString *)title textFont:(UIFont *)textFont
{
    QGGradientShadowButton * button = [QGGradientShadowButton buttonWithType:UIButtonTypeCustom];
    if (title) {
        [button setTitle:title forState:UIControlStateNormal];
    }
    if (textFont) {
        button.titleLabel.font = textFont;
    }
    if (superView) {
        [superView addSubview:button];
    }
    return button;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self.layer insertSublayer:self.gradientLayer below:self.imageView.layer];
        self.gradientLayer.startPoint = CGPointMake(0, 0.5);
        self.gradientLayer.endPoint = CGPointMake(1, 0.5);
        self.gradientLayer.colors = [UIColor gradientColors];
        self.gradientLayer.locations = @[@(0.15),@(0.85)];
    }
    return self;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    self.gradientLayer.frame = self.bounds;
    if (!self.isClearCorner) {
        self.gradientLayer.cornerRadius = CGRectGetHeight(self.frame)/2.0;
        self.layer.cornerRadius = CGRectGetHeight(self.frame)/2.0;
    }
}

- (CAGradientLayer *)gradientLayer
{
    if (!_gradientLayer) {
        _gradientLayer = [CAGradientLayer layer];
    }
    return _gradientLayer;
}

/**
 设置按钮是否能点击
 */
- (void)setGradientButtonIsClickEnabled:(BOOL)isEnabled
{
    self.userInteractionEnabled = isEnabled;
    if (isEnabled) {
        self.gradientLayer.colors = [UIColor gradientColors];
    }
    else
    {
        self.gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"BFBFBF"].CGColor,(id)[UIColor colorWithHexString:@"DBDBDB"].CGColor];;
    }
}

- (void)setIsClearCorner:(BOOL)isClearCorner
{
    if (_isClearCorner != isClearCorner) {
        _isClearCorner = isClearCorner;
        if (_isClearCorner) {
            self.gradientLayer.cornerRadius = 0;
            self.layer.cornerRadius = 0;
        }
    }
}

@end
