//
//  QGGradientProgressView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/16.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGGradientProgressView.h"
#import "QGBasicUITool.h"

@interface QGGradientProgressView ()

/// 遮罩进度层
@property (nonatomic, strong) CALayer * progressLayer;

/// 渐变图层
@property (nonatomic, strong, readwrite) CAGradientLayer * gradientLayer;

@end

@implementation QGGradientProgressView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //进度条底色
        self.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        self.clipsToBounds = YES;
        
        //遮罩层
        self.progressLayer = [CALayer layer];
        self.progressLayer.masksToBounds = YES;

        //渐变图层
        self.gradientLayer = [CAGradientLayer layer];
        self.gradientLayer.masksToBounds = YES;
        self.gradientLayer.colors = [UIColor gradientColors];
        self.gradientLayer.locations = @[@0.1,@0.9];
        self.gradientLayer.startPoint = CGPointMake(0, 0);
        self.gradientLayer.endPoint = CGPointMake(1, 0);
        self.gradientLayer.mask = self.progressLayer;
        [self.layer addSublayer:self.gradientLayer];
       
    }
    return self;
}


- (void)layoutSubviews
{
    self.layer.cornerRadius = self.height/2.0;
    
    self.progressLayer.frame = CGRectMake(0, 0, self.width * self.progress, self.height);
    self.progressLayer.cornerRadius = self.height / 2.0;
    self.progressLayer.borderWidth = self.height / 2.0;
    
    self.gradientLayer.frame = self.bounds;
    self.gradientLayer.cornerRadius = self.height / 2;
}


- (void)setProgress:(CGFloat)progress
{
    if (_progress != progress) {
        _progress = MAX(MIN(progress, 1), 0);
        self.progressLayer.frame = CGRectMake(0, 0, self.width * _progress, self.height);
    }
}

@end
