//
//  QGBadNetworkReloadView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/10.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGDefaultView.h"
#import "QGBasicUITool.h"
#import "UIButton+QGAdd.h"
#import "NSString+CreditWallet.h"
@interface QGDefaultView ()

/**
 图标
 */
@property (nonatomic, strong) UIImageView * iconImageView;

/**
 状态提示文案
 */
@property (nonatomic, strong) UILabel * messageLabel;

/**
 重试按钮
 */
@property (nonatomic, strong) UIButton * reloadButton;

/**
 刷新回调
 */
@property (nonatomic, copy) dispatch_block_t reloadBlock;
@end


@implementation QGDefaultView

/**
 *  提示用户网络不好，并可以手动刷新
 *
 *  @param superView 父视图
 *
 *  @return 目标视图
 */
+ (QGDefaultView *)defaultViewShowWithSuperView:(UIView *)superView reloadBlock:(dispatch_block_t)reloadBlock;
{
    return [self defaultViewShowWithSuperView:superView inset:UIEdgeInsetsZero reloadBlock:reloadBlock];
}

/**
 *  提示用户网络不好，并可以手动刷新
 *
 *  @param superView 父视图
 *
 *  @return 目标视图
 */
+ (QGDefaultView *)defaultViewShowWithSuperView:(nullable UIView *)superView inset:(UIEdgeInsets)inset reloadBlock:(_Nullable dispatch_block_t)reloadBlock
{
    QGDefaultView * networkView = [[QGDefaultView alloc]init];
    networkView.reloadBlock = reloadBlock;
    if (superView) {
        [superView addSubview:networkView];
        [networkView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(inset.left);
            make.right.inset(inset.right);
            make.bottom.inset(inset.bottom);
            make.top.inset(inset.top);
        }];
    }
    return networkView;
}


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initNormalUI];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self  = [super initWithCoder:aDecoder]) {
        [self initNormalUI];
    }
    return self;
}


- (void)initNormalUI
{
    self.backgroundColor = [UIColor whiteColor];
    UIView * contentView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor clearColor]];
    [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.offset(0);
        make.centerY.mas_equalTo(self.mas_bottom).multipliedBy(0.45);
        make.width.mas_equalTo(self.mas_width);
    }];
    
    //图片
    self.iconImageView = [UIView creatImageViewWithSuperView:contentView imageName:@""];
    [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_offset(10);
        make.centerX.offset(0);
    }];
    
    //网络提示
    self.messageLabel = [UIView creatLabelWithSuperView:contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor6666] alignment:NSTextAlignmentCenter];
    [self.messageLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.iconImageView.mas_bottom).offset(5);
        make.centerX.offset(0);
    }];
    
    //重新加载
    self.reloadButton = [UIView creatButtonWithSuperView:contentView title:nil titleFont:[UIFont qg_lightFontOfSize:14] textColor:[UIColor mainThemeColor]];
    [self.reloadButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.messageLabel.mas_bottom).offset(20);
        make.size.mas_equalTo(CGSizeMake(120, 30));
        make.centerX.offset(0);
        make.bottom.mas_equalTo(contentView.mas_bottom).offset(-10);
    }];
    [self.reloadButton setBorder:[UIColor mainThemeColor] width:.5];
    self.reloadButton.layer.cornerRadius = 30/2;
    self.reloadButton.clipsToBounds = YES;
    
    
    __weak typeof(self) weakSelf = self;
    [self.reloadButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
        if (weakSelf.reloadBlock) {
            weakSelf.reloadBlock();
        }
        
        //只有网络不好的视图会点击按钮时移除
        if (weakSelf.viewType == QGDefaultViewTypeBadNetwork) {
            [weakSelf dismiss];
        }
    }];
}


- (void)dealloc {
    self.reloadBlock = nil;
}


- (void)setViewType:(QGDefaultViewType)viewType
{
    if (_viewType != viewType) {
        _viewType = viewType;
        
        if (_viewType == QGDefaultViewTypeBadNetwork) {
            self.messageLabel.text = @"网络找不到了，请刷新重试～";
            [self.reloadButton setTitle:@"刷新" forState:UIControlStateNormal];
            self.iconImageView.image = [UIImage imageNamed:@"bad_network"];
            self.reloadButton.hidden = NO;
        }
        
    }
}


/**
 设置图片和标题文案
 
 @param imageName 图片名字
 @param messageTitle 描述文案
 @param buttonTitle 按钮文案
 */
- (void)setIconImageWithImageName:(NSString *)imageName messageTitle:(NSString *)messageTitle buttonTitle:( NSString * _Nullable)buttonTitle
{
    if (![NSString isEmpty:imageName]) {
        self.iconImageView.image = [UIImage imageNamed:imageName];
    }
    
    if (![NSString isEmpty:messageTitle]) {
        self.messageLabel.text = messageTitle;
    }
    
    if (![NSString isEmpty:buttonTitle]) {
        [self.reloadButton setTitle:buttonTitle forState:UIControlStateNormal];
    }
}

/**
 隐藏方法
 */
- (void)dismiss
{
    [self removeFromSuperview];
}

@end
