//
//  QGBadNetworkReloadView.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/10.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, QGDefaultViewType) {
    ///默认的缺省页
    QGDefaultViewTypeNormal,
    ///网络不好的情况
    QGDefaultViewTypeBadNetwork,
};


@interface QGDefaultView : UIView


/**
 缺省图的样式，默认是普通的
 */
@property (nonatomic, assign) QGDefaultViewType viewType;

/**
 图标
 */
@property (nonatomic, strong, readonly) UIImageView * iconImageView;

/**
 状态提示文案
 */
@property (nonatomic, strong, readonly) UILabel * messageLabel;

/**
 重试按钮
 */
@property (nonatomic, strong, readonly) UIButton * reloadButton;

/**
 *  提示用户网络不好，并可以手动刷新
 *
 *  @param superView 父视图
 *
 *  @return 目标视图
 */
+ (QGDefaultView *)defaultViewShowWithSuperView:(nullable UIView *)superView reloadBlock:(_Nullable dispatch_block_t)reloadBlock;

/**
 *  提示用户网络不好，并可以手动刷新
 *
 *  @param superView 父视图
 *
 *  @return 目标视图
 */
+ (QGDefaultView *)defaultViewShowWithSuperView:(nullable UIView *)superView inset:(UIEdgeInsets)inset reloadBlock:(_Nullable dispatch_block_t)reloadBlock;

/**
 设置图片和标题文案

 @param imageName 图片名字
 @param messageTitle 描述文案
 @param buttonTitle 按钮文案
 */
- (void)setIconImageWithImageName:(NSString *)imageName messageTitle:(NSString *)messageTitle buttonTitle:(NSString * _Nullable)buttonTitle;


/**
 消失方法
 */
- (void)dismiss;

@end

NS_ASSUME_NONNULL_END
