//
//  QGDashPatternView.h
//  VirtualPayment
//
//  Created by 张博 on 2019/8/7.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, QGDashPatternViewType) {
    ///上方虚线
    QGDashPatternViewTypeTop,
    ///左方虚线
    QGDashPatternViewTypeLeft,
    ///下方虚线
    QGDashPatternViewTypeBottom,
    ///右方虚线
    QGDashPatternViewTypeRight,
    ///四周虚线
    QGDashPatternViewTypeRound,
};

NS_ASSUME_NONNULL_BEGIN

/**
 虚线图案
 */
@interface QGDashPatternView : UIView


/**
 初始化虚线实例
 
 @param dashPatternType 虚线的类型 上、下、左、右、四周
 @param lineColor 虚线的颜色
 @param lineWidth 虚线的宽度
 @param lineDashPattern lineDashPatter @[@a,@b] a:虚线长度，b:两虚线间隔长度
 @return 实例对象
 */
- (instancetype)initWithDashPatternType:(QGDashPatternViewType)dashPatternType lineColor:(UIColor *)lineColor lineWidth:(CGFloat)lineWidth lineDashPattern:(NSArray *)lineDashPattern;


/**
 初始化虚线实例 - 带圆角
 
 @param dashPatternType 虚线的类型 上、下、左、右、四周
 @param cornerRadius 圆角的弧度
 @param lineColor 虚线的颜色
 @param lineWidth 虚线的宽度
 @param lineDashPattern lineDashPatter @[@a,@b] a:虚线长度，b:两虚线间隔长度
 @return 实例对象
 */
- (instancetype)initWithDashPatternType:(QGDashPatternViewType)dashPatternType cornerRadius:(CGFloat)cornerRadius lineColor:(UIColor *)lineColor lineWidth:(CGFloat)lineWidth lineDashPattern:(NSArray *)lineDashPattern;


@end

NS_ASSUME_NONNULL_END
