//
//  QGCustomTitleVIew.m
//  VirtualPayment
//
//  Created by silicn on 2019/7/8.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCustomTitleVIew.h"
#import "QGBasicUITool.h"

@interface QGCustomTitleVIew()

@property (nonatomic, strong)UILabel *titleLab;


@end

@implementation QGCustomTitleVIew

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.titleLab = [UILabel creatLabelWithSuperView:self title:@"" titleFontSize:[UIFont qg_mediumFontOfSize:17.0] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
    
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.centerY.equalTo(self);
    }];
}
- (void)setTitle:(NSString *)title
{
    if (_title != title) {
        _title = title;
        self.titleLab.text = title;
    }
}

- (void)setTextColor:(UIColor *)textColor
{
    if (_textColor != textColor) {
        _textColor = textColor;
        self.titleLab.textColor = textColor;
    }
}

- (CGSize)intrinsicContentSize {
    return UILayoutFittingCompressedSize;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
