//
//  ZHAnimationBaseView.h
//  GoodTodayCustomer
//
//  Created by zhangbo on 16/4/7.
//  Copyright © 2016年 zhangbo. All rights reserved.
//


#import <UIKit/UIKit.h>

typedef enum : NSUInteger {
    ZHAnimationTypeActionSheet,    //由下往上弹出动画
    ZHAnimationTypeAlert,          //alertView动画
} ZHAnimationType;  //动画类型

#define KAniamtionDuration .25f //动画时间
//点击取消时执行的block
typedef void(^ZHAniamtionDismissBlock)();


@interface ZHAnimationBaseView : UIView

/**
 * 阴影视图下面的视图，透明度默认为0 当弹出动画时，需要在阴影底部做其他动画时使用
 */
@property (nonatomic, strong, readonly) UIView * belowShadowView;

/**
 阴影层弹出动画时的透明度  默认 .5
 */
@property (nonatomic, assign) CGFloat shadowViewAnimationAlpha;

/**
 *  点击背景是否关闭
 */
@property (nonatomic, assign) BOOL isCancleClickBackground;

/**
 是否需要底部的安全区域适配
 ZHAnimationTypeActionSheet 时，如果有底部按钮，需要设置此参数为YES
 在iPhone X上底部会适配安全区域
 */
@property (nonatomic, assign) BOOL isNeedSafeBottomMargin;

/**
 *  动画类型  默认是第一个
 */
@property (nonatomic, assign) ZHAnimationType animationType;

/**
 *  取消回调
 */
@property (nonatomic, copy) ZHAniamtionDismissBlock dismissBlock;


/**
 初始化  子类可以继承添加新的设置
 */
- (void)initNormalUI NS_REQUIRES_SUPER;

/**
 *  显示出来
 */
- (void)showAnimation:(BOOL)animation;


/**
 显示出来到view上
 */
- (void)showWithView:(UIView *)view animation:(BOOL)animation;

/**
 *  隐藏
 */
- (void)dismissAnimation:(BOOL)animation dismissBlock:(BOOL)isBlock;


/**
 点击背景的回调事件
 */
- (void)cancleButtonClick;


@end
