//
//  QGShareView.h
//  VirtualPayment
//
//  Created by silicn on 2019/12/5.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "QGThirdPlatformService.h"

typedef NS_ENUM(NSUInteger, QGShareModelObjType) {
    ///多媒体分享
    QGShareModelObjTypeNormal,
    ///图片分享
    QGShareModelObjTypeImage,
};


@interface QGShareModel : QGBaseModel

/// 分享的标题
@property (nonatomic, copy)NSString * _Nullable title;
/// 分享的图标
@property (nonatomic, copy)NSString * _Nullable imgUrl;
/// 图片
@property (nonatomic, copy)UIImage * _Nullable image;
/// 分享的描述文字
@property (nonatomic, copy)NSString * _Nullable desc;
/// 分享的链接
@property (nonatomic, copy)NSString * _Nullable link;

/// 分享类型 多媒体分享 | 图片分享
@property (nonatomic, assign) QGShareModelObjType shareObjType;

- (NSDictionary *_Nonnull)convertToShareDic;

@end



#import "QGBasePopView.h"

///分享回调
typedef void(^QGShareViewResultBlock)(BOOL isSuccess);

///分享中的回调
typedef void(^QGShareViewSharingBlock)(QGShareItemType shareItemType);

NS_ASSUME_NONNULL_BEGIN

@interface QGShareView : QGBasePopView

/// 回调结果
@property (nonatomic, copy) QGShareViewResultBlock resultBlock;

/// 分享中 | 不会打断分享操作
@property (nonatomic, copy) QGShareViewSharingBlock sharingBlock;

/// 接管分享事件
@property (nonatomic, copy) QGShareViewSharingBlock takeOverShareBlock;


/// 指定初始化方法
/// @param items 当前可分享的平台:@[@(QGShareItemTypeWeChat),@(QGShareItemTypeTimeLine)];
/// @discuss     如果items为nil,则默认全平台分享
/// @param model 分享的内容,如果为nil,默认分享错误
- (instancetype)initWithItems:(nullable NSArray<NSNumber *> *)items shareModel:(nullable QGShareModel *)model;

@end

NS_ASSUME_NONNULL_END
