//
//  QGBasePopView.m
//  VirtualPayment
//
//  Created by silicn on 2019/5/16.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBasePopView.h"
#import "Masonry.h"

#import "DeviceAdaptation.h"

#import "AppDelegate.h"


@interface QGBasePopView()<UIGestureRecognizerDelegate>

@property (nonatomic, strong)UIView *contentView;

@property (nonatomic, strong)UIView *safeView;

@property (nonatomic, strong)UITapGestureRecognizer *tap;


@end


@implementation QGBasePopView

- (UITapGestureRecognizer *)tap
{
    if (!_tap) {
        _tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(disMiss:)];
        _tap.delegate = self;
    }
    return _tap;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    frame = CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height);
    self = [super initWithFrame:frame];
    if (self) {
        
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
        [self addSubview:self.safeView];
        [self addSubview:self.contentView];
        
        self.shadowViewAnimationAlpha = 0.3;
        
        self.dissMissClickBackground = YES;
        self.popType = PopViewTypeAlert;
        [self initNomalUI];
    }
    return self;
}

/**
 设置contentView的布局方式
 */
- (void)layoutContentView
{
    if (self.popType == PopViewTypeAlert) {
        self.safeView.hidden = YES;
        [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self).inset(kLR_Margin);
            make.height.greaterThanOrEqualTo(@(55));
            make.centerY.equalTo(self.mas_centerY);
            make.height.lessThanOrEqualTo(@([UIScreen mainScreen].bounds.size.height - 32));
        }];
        self.contentView.layer.cornerRadius = 8;
        self.contentView.clipsToBounds = YES;
       
    }else if (self.popType == PopViewTypeActionSheet){
        self.safeView.hidden = NO;
        [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.mas_bottom);
            make.height.greaterThanOrEqualTo(@(55));
            make.left.right.equalTo(self);
        }];
        
        [self.safeView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView);
            make.top.equalTo(self.contentView.mas_bottom);
            make.height.mas_equalTo([DeviceAdaptation getBottomSafeAreaHeight]);
        }];
        
        self.contentView.layer.cornerRadius = 0;
        self.contentView.clipsToBounds = YES;
    }
}

/**
 设置弹出类型

 @param popType PopViewType
 */
- (void)setPopType:(PopViewType)popType
{
    _popType = popType;
    [self layoutContentView];
}


/**
 设置点击灰色部分是否Dismiss

 @param dissMissClickBackground BOOL
 */
- (void)setDissMissClickBackground:(BOOL)dissMissClickBackground
{
    _dissMissClickBackground = dissMissClickBackground;
    if (dissMissClickBackground) {
        if ([self.gestureRecognizers containsObject:self.tap]) return;
        [self addGestureRecognizer:self.tap];
    }else{
        [self removeGestureRecognizer:self.tap];
    }
}

- (void)disMiss:(UITapGestureRecognizer *)tap
{
    [self dismissView:NULL];
}


- (void)initNomalUI
{
}

- (void)showInView:(nullable UIView *)superView
{
    self.contentView.alpha = 1.0;
    UIWindow *window = superView.window ? superView.window:[self getKeyWindow];
    [window addSubview:self];
    //self添加约束
    [self mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.right.left.equalTo(window); 
    }];
    if (self.popType == PopViewTypeActionSheet) {
        [self layoutIfNeeded];   //布局一下self.contentView的视图位置
        //为contentView重新添加视图
        if (@available(iOS 11.0, *)) {
            [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.bottom.equalTo(self.mas_safeAreaLayoutGuide);
                make.height.greaterThanOrEqualTo(@(55));
                make.height.lessThanOrEqualTo(@([UIScreen mainScreen].bounds.size.height - 40 - [DeviceAdaptation getBottomSafeAreaHeight]));
            }];
        }else{
            [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.right.bottom.equalTo(self);
                make.height.greaterThanOrEqualTo(@(55));
                make.height.lessThanOrEqualTo(@([UIScreen mainScreen].bounds.size.height - 40));
            }];
        }
       //contentView缓慢从底部滑行出现
        [UIView animateWithDuration:0.25 delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
            self.backgroundColor = [UIColor colorWithWhite:0 alpha:self.shadowViewAnimationAlpha];
            [self layoutIfNeeded];
        } completion:NULL];
        
    }else{
        //Alert类型动画
        self.contentView.layer.transform = CATransform3DMakeScale(1.1f, 1.1f, 1.0f);
        [UIView animateWithDuration:0.25f delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
            self.backgroundColor = [UIColor colorWithWhite:0 alpha:self.shadowViewAnimationAlpha];
            self.contentView.layer.transform = CATransform3DIdentity;
        } completion:NULL];
    }

}

- (void)dismissView:(nullable PopViewDisMissBlock)dismissBlock
{
    if (self.popType == PopViewTypeActionSheet) {
        //重新设置contentView的约束
        [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.mas_bottom);
            make.height.greaterThanOrEqualTo(@(55));
            make.left.right.equalTo(self);
        }];
        //contentView缓慢滑出视图
        [UIView animateWithDuration:0.25  delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
            
            self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
            [self layoutIfNeeded];
        } completion:^(BOOL finished) {
            [self removeFromSuperview];
        }];
    }else{
        [self layoutIfNeeded];
        [UIView animateWithDuration:0.25 animations:^{
            self.contentView.alpha = 0.0f;
            self.backgroundColor = [UIColor colorWithWhite:0 alpha:0];
        } completion:^(BOOL finished) {
            [self removeFromSuperview];
        }];
    }
    if (dismissBlock) {
        dismissBlock();
    }
}



//判断手势点击的视图，如果在contentView上，不响应
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    if ([touch.view isDescendantOfView:_contentView]) {
        return NO;
    }
    return YES;
}

- (UIView *)contentView
{
    if (!_contentView) {
        _contentView = [[UIView alloc]init];
        _contentView.backgroundColor = [UIColor whiteColor];
    }
    return _contentView;
}

- (UIView *)safeView
{
    if (!_safeView) {
        _safeView = [[UIView alloc]init];
        _safeView.backgroundColor = [UIColor whiteColor];
    }
    return _safeView;
}

///获取当前主Window
- (UIWindow *)getKeyWindow
{
    NSEnumerator *frontToBackWindows = [UIApplication.sharedApplication.windows reverseObjectEnumerator];
    UIWindow * keyWindow = nil;
    for (UIWindow *window in frontToBackWindows){
        BOOL windowOnMainScreen = window.screen == UIScreen.mainScreen;
        BOOL windowIsVisible = !window.hidden && window.alpha > 0;
        BOOL windowLevelNormal = window.windowLevel == UIWindowLevelNormal;
        
        if (windowOnMainScreen && windowIsVisible && windowLevelNormal) {
            keyWindow = window;
            break;
        }
    }
    if (keyWindow ==nil) {
        return  ((AppDelegate*)([UIApplication sharedApplication].delegate)).window;
    }
    return keyWindow;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
