//
//  QGAlertView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAlertView.h"
#import "QGBasicUITool.h"
#import "NSString+CreditWallet.h"
#import "UIButton+QGAdd.h"
@interface QGAlertView ()

/**
 取消按钮
 */
@property (nonatomic, strong) UIButton * cancelButton;

/**
 确定按钮
 */
@property (nonatomic, strong) UIButton * sureButton;


/// 标题
@property (nonatomic, strong, readwrite) UILabel * titleLabel;
/// 滑动背景
@property (nonatomic, strong) UIScrollView *scrollView;
/// 弹窗信息主体
@property (nonatomic, strong, readwrite) UILabel * messageLabel;

/// ------------线
@property (nonatomic, strong) UIView *lineSep ;
///    |
///    |
///    线
@property (nonatomic, strong) UIView *centerLine ;

/**
 点击事件回调
 */
@property (nonatomic, copy) QGAlertViewButtonClick clickBlock;
@end

@implementation QGAlertView


- (id)init
{
    self = [super init];
    if (self) {
        self.alertStyle = QGAlertStyleNomal;
    }
    return self;
}

/**
 实例化方法
 
 @param title 标题
 @param message 主要信息
 @param cancelButtonTitle 取消按钮
 @param sureButtonTitle 确认按钮
 @return 实例对象
 */
- (QGAlertView *)initWithTitle:(nullable NSString *)title message:(nonnull NSString *)message cancelButtonTitle:(nullable NSString *)cancelButtonTitle sureButtonTitle:(nullable NSString *)sureButtonTitle clickBlock:(nullable QGAlertViewButtonClick)clickBlock
{
    if (self = [super init]) {
        [self creatSubViewsWithTitle:title message:message cancelButtonTitle:cancelButtonTitle sureButtonTitle:sureButtonTitle clickBlock:clickBlock];
    }
    return self;
}

///添加子视图
- (void)creatSubViewsWithTitle:(nullable NSString *)title message:(nonnull NSString *)message cancelButtonTitle:(nullable NSString *)cancelButtonTitle sureButtonTitle:(nullable NSString *)sureButtonTitle clickBlock:(QGAlertViewButtonClick)clickBlock;
{
    //如果没有展示的主体信息，后面的不会创建
    if ([NSString isEmpty:message]) {
        return;
    }
    
    //标题
    if (![NSString isEmpty:title]) {
        self.titleLabel = [UIView creatLabelWithSuperView:self.contentView title:title titleFontSize:[UIFont qg_lightFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.mas_equalTo(self.contentView).offset(20);
            make.right.mas_equalTo(self.contentView).offset(-20);
            make.height.mas_equalTo(@(25));
        }];
    }
    
    self.scrollView = [[UIScrollView alloc]init];
    self.scrollView.showsVerticalScrollIndicator = YES;
    self.scrollView.showsHorizontalScrollIndicator = NO;
    [self.contentView addSubview:_scrollView];
    
    //内容
    UIFont * messageFont = [NSString isEmpty:title] ? [UIFont qg_lightFontOfSize:18] : [UIFont qg_lightFontOfSize:15];
    UIColor * messageColor = [NSString isEmpty:title] ? [UIColor textColor3333] : [UIColor textColor9999];
    self.messageLabel = [UIView creatLabelWithSuperView:self.scrollView title:message titleFontSize:messageFont textColor:messageColor alignment:NSTextAlignmentCenter];
    self.messageLabel.numberOfLines = 0;
    
    [self.messageLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.equalTo(self.scrollView);
        make.width.equalTo(self.scrollView.mas_width);
    }];
    
    //如果行数大于一行，则更换展示方式
    [self.messageLabel sizeToFit];
    if (CGRectGetHeight(self.messageLabel.frame) > messageFont.lineHeight + 1) {
        self.messageLabel.textAlignment = NSTextAlignmentLeft;
    }
    
    //根据是否有title而具有不同的约束
    //没有title的约束
    if ([NSString isEmpty:title]) {
        [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(25);
            make.top.inset(33);
            make.height.equalTo(self.messageLabel.mas_height).priorityLow();
            make.height.lessThanOrEqualTo(self.contentView.mas_height).priorityHigh();
        }];
    }
    else
    {
        [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.equalTo(self.titleLabel.mas_bottom).offset(16);
            make.height.equalTo(self.messageLabel.mas_height).priorityLow();
            make.height.lessThanOrEqualTo(self.contentView.mas_height).priorityHigh();
        }];
    }
    
    //分割线条
    UIView * lineSep = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
    [lineSep mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.scrollView.mas_bottom).offset(26);
        make.left.right.mas_equalTo(self.contentView);
        make.height.mas_equalTo(@(0.5));
    }];
    self.lineSep = lineSep;
    
    //中间的分割线
    UIView * centerLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
    [centerLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(lineSep.mas_bottom).offset(0);
        make.width.mas_equalTo(@(0.5));
        make.centerX.mas_equalTo(self.contentView);
        make.height.mas_equalTo(@(54));
        make.bottom.equalTo(self.contentView);
    }];
    self.centerLine = centerLine;
    
    __weak typeof(self) weakSelf = self;
    //底部按钮
    //确定按钮存在
    if (![NSString isEmpty:sureButtonTitle]) {
        self.sureButton = [UIView creatButtonWithSuperView:self.contentView title:sureButtonTitle titleFont:[UIFont qg_regularFontOfSize:18] textColor:[UIColor yyMainThemeColor]];
        [self.sureButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            [weakSelf buttonClickWithIndex:1];
        }];
    }
    
    //取消按钮存在
    if (![NSString isEmpty:cancelButtonTitle]) {
        self.cancelButton = [UIView creatButtonWithSuperView:self.contentView title:cancelButtonTitle titleFont:[UIFont qg_lightFontOfSize:18] textColor:[UIColor textColor3333]];
        [self.cancelButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            [weakSelf buttonClickWithIndex:0];
        }];
    }
    
    //两个按钮都存在
    if (self.sureButton && self.cancelButton) {
        //取消在左边
        [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.contentView);
            make.top.mas_equalTo(lineSep.mas_bottom);
            make.bottom.mas_equalTo(self.contentView);
            make.right.mas_equalTo(centerLine.mas_left);
        }];
        
        //确认在右边
        [self.sureButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(centerLine.mas_right);
            make.top.mas_equalTo(lineSep.mas_bottom);
            make.bottom.mas_equalTo(self.contentView);
            make.right.mas_equalTo(self.contentView);
        }];
    }
    //只存在一个按钮
    else if (self.sureButton)
    {
        [self.sureButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.mas_equalTo(self.contentView);
            make.top.mas_equalTo(lineSep.mas_bottom);
        }];
        centerLine.hidden = YES;
    }
    //只有取消按钮
    else if (self.cancelButton)
    {
        [self.cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.mas_equalTo(self.contentView);
            make.top.mas_equalTo(lineSep.mas_bottom);
        }];
        centerLine.hidden = YES;
    }
    
    self.clickBlock = clickBlock;
    self.dissMissClickBackground = NO;
}

#pragma mark - Action
///按钮点击事件
- (void)buttonClickWithIndex:(NSInteger)index
{
    if (self.clickBlock) {
        self.clickBlock(index);
    }
    [self dismissView:nil];
    
}


#pragma mark - Setter
- (void)setSureButtonTextColor:(UIColor *)sureButtonTextColor
{
    if (_sureButtonTextColor != sureButtonTextColor) {
        _sureButtonTextColor = sureButtonTextColor;
        [self.sureButton setTitleColor:_sureButtonTextColor forState:UIControlStateNormal];
    }
}

- (void)setCancleButtonTextColor:(UIColor *)cancleButtonTextColor
{
    if (_cancleButtonTextColor != cancleButtonTextColor) {
        _cancleButtonTextColor = cancleButtonTextColor;
        [self.cancelButton setTitleColor:_cancleButtonTextColor forState:UIControlStateNormal];
    }
}

#pragma mark - 重写父类的显示方法

- (void)showInView:(nullable UIView *)superView
{
    self.contentView.alpha = 1.0;
    UIWindow *window = superView.window ? superView.window:[self getKeyWindow];
    [window addSubview:self];
    //self添加约束
    [self mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.right.left.equalTo(window);
    }];
    
    //Alert类型动画
    [self.contentView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self).inset(kLR_Margin);
        make.height.greaterThanOrEqualTo(@(55));
        make.centerY.equalTo(self.mas_centerY);
        make.height.lessThanOrEqualTo(self.mas_height).multipliedBy(0.55);
    }];
    
    self.contentView.layer.transform = CATransform3DMakeScale(1.1f, 1.1f, 1.0f);
    [UIView animateWithDuration:0.25f delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:self.shadowViewAnimationAlpha];
        self.contentView.layer.transform = CATransform3DIdentity;
    } completion:NULL];
    
}

- (void)setAlertStyle:(QGAlertStyle)alertStyle
{
    if (_alertStyle != alertStyle) {
        _alertStyle = alertStyle;
        /// 设置样式
        [self setupStyle:alertStyle];
    }
}

- (void)setupStyle:(QGAlertStyle)alertStyle
{
    if (alertStyle == QGAlertStyleBlack) {
        self.contentView.backgroundColor = [UIColor colorWithHexString:@"#1B1515"];
        self.messageLabel.backgroundColor = self.scrollView.backgroundColor = self.contentView.backgroundColor;
        self.messageLabel.textColor = [UIColor colorWithWhite:1.0 alpha:0.8];
        self.titleLabel.textColor = self.messageLabel.textColor;
        [self.sureButton setTitleColor:[UIColor colorWithHexString:@"#E9B176"] forState:UIControlStateNormal];
        [self.cancelButton setTitleColor:[UIColor colorWithHexString:@"#E9B176"] forState:UIControlStateNormal];
        self.lineSep.backgroundColor = self.centerLine.backgroundColor = [UIColor colorWithHexString:@"#dcdcdc"alpha:0.2];
    }else{
        self.contentView.backgroundColor = self.scrollView.backgroundColor = self.messageLabel.backgroundColor = UIColor.whiteColor;
        self.titleLabel.textColor = UIColor.whiteColor;
        self.messageLabel.backgroundColor = UIColor.whiteColor;
        [self.sureButton setTitleColor:[UIColor yyMainThemeColor] forState:UIControlStateNormal];
        [self.cancelButton setTitleColor:UIColor.textColor3333 forState:UIControlStateNormal];
         self.lineSep.backgroundColor = self.centerLine.backgroundColor = UIColor.lineSeparatorColorDCDC;
    }
}


@end
