//
//  QGActionSheetView.m
//  VirtualPayment
//
//  Created by 胡红磊 on 2019/7/1.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGActionSheetView.h"
#import "QGBasicUITool.h"
#import "NSString+CreditWallet.h"
#import "UIButton+QGAdd.h"

@interface QGActionSheetView ()<UITableViewDelegate,UITableViewDataSource>

/**
 标题
 */
@property (nonatomic, copy)NSString *title;

@property (nonatomic, assign)CGFloat titleHeight;

@property (nonatomic, copy)NSArray *options;

/**
 作用为:选项标签
 */
@property (nonatomic, strong) UITableView *tableView;

/**
 点击事件回调
 */
@property (nonatomic, copy) QGActionSheetButtonClick clickBlock;

@end

@implementation QGActionSheetView

- (void)dealloc {
    //安全处理
    if (_tableView) {
        self.tableView.delegate = nil;
        self.tableView.dataSource = nil;
    }
}

/**
 实例化方法
 
 @param title 标题
 @param options 选项标题
 @param clickBlock 点击的block
 @return 实例对象
 */
- (QGActionSheetView *)initWithTitle:(nullable NSString *)title
                             options:(NSArray *)options
                          clickBlock:(QGActionSheetButtonClick)clickBlock{
    
    if (self = [super init]) {
        
        self.title = title;
        self.options = options;
        self.clickBlock = clickBlock;
        self.popType = PopViewTypeActionSheet;
        
        //判断是否传选项标题
        if (![NSString isEmpty:title]) {
            self.titleHeight = 50;
        }else{
            self.titleHeight = 1;
        }
        
        self.tableView = [[UITableView alloc] init];
        self.tableView.showsVerticalScrollIndicator = NO;
        self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        self.tableView.delegate = self;
        self.tableView.dataSource = self;
        self.tableView.scrollEnabled = NO;
        [self.contentView addSubview:self.tableView];
        self.tableView.tableHeaderView = [self creatHeaderView];
        //第一分区标签数组
        NSArray *fristArr = self.options[0];
        [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.mas_equalTo(self.contentView);
            make.height.mas_equalTo(@(64*(fristArr.count+1)+10 + self.titleHeight));
            make.bottom.equalTo(self.contentView);
        }];
    }
    
    return self;
}

///tableView的头视图
- (UIView *)creatHeaderView{
    
    UIView *view = [[UIView alloc] init];
    view.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, self.titleHeight);
    
    if (![NSString isEmpty:_title]) {
        UILabel *title = [UIView creatLabelWithSuperView:view title:_title titleFontSize:[UIFont qg_regularFontOfSize:13] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [view addSubview:title];
        [title mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.mas_equalTo(view);
        }];
    }
    
    UIView *lineSep = [UIView creatViewWithSuperView:view backgroundColor:[UIColor lineSeparatorColorDCDC]];
    [lineSep mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(view);
        make.bottom.mas_equalTo(view.mas_bottom);
        make.height.mas_equalTo(@(1));
    }];
    
    return view;
}


- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section{
    
    UIView *view = [[UIView alloc] init];
    view.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    return view;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section{
    
    return section == 0 ? CGFLOAT_MIN : 10 ;
}

- (UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section{
    
    UIView *view = [UIView new];
    return view;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section{
    
    return CGFLOAT_MIN;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    
    return self.options.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    
    return [_options[section] count];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    return 64;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    
     QGActionSheetTableViewCell *cell = (QGActionSheetTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGActionSheetTableViewCell class]) dequeueTableView:tableView];
    cell.titleLabel.text = self.options[indexPath.section][indexPath.row];
    
    if (([self.options[indexPath.section] count] - 1) == indexPath.row) {
        cell.lineSep.hidden = YES;
    }
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    [self dismissView:nil];
    
    if (indexPath.section == 1) {
        //取消
        if (self.clickBlock) {
            self.clickBlock(0);
        }
        
    }else{
        
        //选项返回是1开始
        if (self.clickBlock) {
            self.clickBlock(indexPath.row + 1);
        }
    }
}

-(UITableViewCell *)getCellFromClassName:(NSString *)className dequeueTableView:(UITableView *)tableView
{
    static NSString * identifier;
    identifier = className;
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        Class class = NSClassFromString(className);
        cell = [[class alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}

@end

@implementation QGActionSheetTableViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.titleLabel = [UIView creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.equalTo(self.contentView);
        }];
        
        self.lineSep = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [self.lineSep mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.equalTo(self.contentView);
            make.height.equalTo(@(1));
        }];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}

@end
