//
//  QGActionSheetView.h
//  VirtualPayment
//
//  Created by 胡红磊 on 2019/7/1.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBasePopView.h"

///按钮点击block
typedef void(^QGActionSheetButtonClick)(NSInteger index);

NS_ASSUME_NONNULL_BEGIN

/**
 功能同系统ActionSheet
 */
@interface QGActionSheetView : QGBasePopView

/**
 实例化方法
 
 @param title 标题
 @param options 选项标题
 @param clickBlock 点击的block(点击取消返回 0, 点击按钮返回数从1开始)
 @return 实例对象
 */
- (QGActionSheetView *)initWithTitle:(nullable NSString *)title
                             options:(NSArray *)options
                          clickBlock:(QGActionSheetButtonClick)clickBlock;

@end




///为选项展示创建cell
@interface QGActionSheetTableViewCell : UITableViewCell

/**
  选项标题
*/
@property (nonatomic, strong)UILabel *titleLabel;

/**
 分割线
 */
@property (nonatomic, strong)UIView *lineSep;

@end

NS_ASSUME_NONNULL_END
