//
//  MagnifyImageView.m
//  Dreamore
//
//  Created by 陈晓宁 on 15/9/16.
//  Copyright (c) 2015年 zhangbo. All rights reserved.
//
#define ScreenWidth [[UIScreen mainScreen] bounds].size.width
#define ScreenHeight [[UIScreen mainScreen] bounds].size.height

#import "MagnifyImageView.h"
#import "DMOScalingImageView.h"
#import "UIImageView+QGWebCache.h"
#import "SystemManager.h"
#import "QGBasicUITool.h"
#import "QGAlertView.h"
#import "QGActionSheetView.h"
#import <Photos/Photos.h>
@interface MagnifyImageView ()<UIScrollViewDelegate>

@property (nonatomic, assign) CGRect defaultRect;

@property (nonatomic, strong) UIPageControl *pageControl;
@property (nonatomic, strong) UIScrollView * scrollView;

/// 图片url数组
@property (nonatomic, strong) NSArray * imageUrlArray;
@end

@implementation MagnifyImageView

#pragma mark - init && configure

- (instancetype)initMagnifyImageViewWithDefault:(UIView*)defaultImageview index:(NSInteger)index allImages:(NSArray *)images{
    if (self = [super initWithFrame:[UIScreen mainScreen].bounds]) {
        [self commonInitWithImages:images imageIndex:index defaultImageView:defaultImageview isNeedPageControl:YES];
    }
    return self;
}

- (instancetype)initMagnifyImageViewWithDefault:(UIView*)defaultImageview index:(NSInteger)index allImages:(NSArray *)images isNeedPageControl:(BOOL)isNeed
{
    if (self = [super initWithFrame:[UIScreen mainScreen].bounds]) {
        [self commonInitWithImages:images imageIndex:index defaultImageView:defaultImageview isNeedPageControl:isNeed];
    }
    return self;
}

- (void)commonInitWithImages:(NSArray *)images imageIndex:(NSUInteger)index defaultImageView:(UIView *)defaultImageView isNeedPageControl:(BOOL)isNeed
{
    [[UIApplication sharedApplication] setStatusBarHidden:YES];
    
    self.imageUrlArray = images;
    
    self.backgroundColor = [UIColor blackColor];
    // init scrollview
    self.scrollView = [[UIScrollView alloc] initWithFrame:[UIScreen mainScreen].bounds];
    self.scrollView.alpha = 0;
    self.scrollView.delegate = self;
    self.scrollView.pagingEnabled = YES;
    self.scrollView.contentSize = CGSizeMake(ScreenWidth * images.count, ScreenHeight);
    self.scrollView.showsHorizontalScrollIndicator = NO;
    self.scrollView.showsVerticalScrollIndicator = NO;
    self.scrollView.backgroundColor = [UIColor blackColor];
    self.scrollView.contentOffset = CGPointMake((index - 1) * ScreenWidth, 0);
    self.scrollView.clipsToBounds = NO;
    [self addSubview:self.scrollView];
    
    
    // add image views
    __weak typeof(self) weakSelf = self;
    for (NSInteger i = 0; i < images.count; i++) {
        DMOScalingImageView *scalingImageView = [[DMOScalingImageView alloc] initWithFrame:CGRectMake(ScreenWidth * i, 0, ScreenWidth, ScreenHeight)];
        scalingImageView.imageURL = [NSURL URLWithString:images[i]];
        @weakify(self);
        scalingImageView.longPressHandler = ^(UIImage *image) {
            @strongify(self);
            [self showSheetView];
        };
        scalingImageView.tapGestureHandler = ^(DMOScalingImageView *scalingImageView) {
            [weakSelf tapGestureHandlerWithScalingImageView:scalingImageView];
        };
        [self.scrollView addSubview:scalingImageView];
    }
    [self.scrollView setContentOffset:CGPointMake(ScreenWidth * index, 0)];
    
    // show animation
    UIWindow * window = [SystemManager getKeyWindow];
    //更新列表中点击图片放大
    self.defaultRect = [defaultImageView convertRect:defaultImageView.bounds toView:window];
//    CGSize size = CGSizeFromString([images[index] objectForKey:@"size"]);
    CGRect frame = self.defaultRect;
    
//    //此操作是保证按照UIViewContentModeScaleAspectFit放大时，不会因为高度不够而使得左右出现黑边
//    frame.size.width = self.defaultRect.size.width<ScreenWidth?self.defaultRect.size.width:ScreenWidth;
//    frame.size.height = size.height/size.width*self.defaultRect.size.width>ScreenHeight?size.height/size.width*self.defaultRect.size.width:ScreenHeight;
//    frame.origin.y -= (frame.size.height-self.defaultRect.size.height)/2;
    self.defaultRect = frame;
    
    UIImageView * showImageView = [[UIImageView alloc] initWithFrame:self.defaultRect];
    showImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    [showImageView setImageWithPlaceholder:@"good_placeholder" URLString:[NSString stringWithFormat:@"%@",images[index]]];
    
    showImageView.backgroundColor = [UIColor clearColor];
    [self addSubview:showImageView];
    
    [UIView animateWithDuration:0.3 animations:^{
        showImageView.frame = CGRectMake(0, 0, ScreenWidth,ScreenHeight);
    } completion:^(BOOL finished) {
        weakSelf.scrollView.alpha = 1.0;
        if (isNeed) {
            [weakSelf addPageControlWithCount:images.count index:index];
        }
        [showImageView removeFromSuperview];
    }];
}

- (void)addPageControlWithCount:(NSUInteger)count index:(NSUInteger)index {
    if (count <= 1) {
        return;
    }
    if (!self.pageControl) {
        self.pageControl = [[UIPageControl alloc] initWithFrame:CGRectMake((ScreenWidth-200)/2, ScreenHeight-50, 200, 50)];
        self.pageControl.tintColor = [UIColor whiteColor];
        [self addSubview:self.pageControl];
        [self.pageControl addTarget:self action:@selector(currentPageChanged:) forControlEvents:UIControlEventValueChanged];
    }
    self.pageControl.numberOfPages = count;
    self.pageControl.currentPage = index;
}

#pragma mark - Gesture && Button Handler

- (void)tapGestureHandlerWithScalingImageView:(DMOScalingImageView *)scalingImageView {
    __weak typeof(self) wSelf = self;
    self.pageControl.alpha = 0;
    
    [[UIApplication sharedApplication] setStatusBarHidden:NO];
    [UIView animateWithDuration:0.5 animations:^{
        wSelf.alpha = 0;
    } completion:^(BOOL finished) {
        [wSelf.scrollView removeFromSuperview];
        wSelf.scrollView = nil;
        wSelf.scrollView.delegate = nil;
        [wSelf.pageControl removeFromSuperview];
        wSelf.pageControl = nil;
        [wSelf removeFromSuperview];
        wSelf.scrollBlock = nil;
    }];
}



- (void)currentPageChanged:(UIPageControl *)pageControl {
    NSInteger index = pageControl.currentPage;
    __weak typeof(self) weakSelf = self;
    [UIView animateWithDuration:.3 animations:^{
        weakSelf.scrollView.contentOffset = CGPointMake(ScreenWidth * index, 0);
    }];
    
    if (self.scrollBlock) {
        self.scrollBlock(index);
    }
}

#pragma mark - UIScrollViewDelegate

-(void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView {
    self.pageControl.currentPage = scrollView.contentOffset.x / ScreenWidth;
    if (self.scrollBlock) {
        self.scrollBlock(self.pageControl.currentPage);
    }
}

- (void)addKeyWindow
{
    [[SystemManager getKeyWindow] addSubview:self];
}


- (void)dealloc
{
    
}

///显示图片保存选项
- (void)showSheetView
{
    @weakify(self);
    QGActionSheetView * sheetView = [[QGActionSheetView alloc] initWithTitle:nil options:@[@[@"保存图片"],@[@"取消"]] clickBlock:^(NSInteger index) {
        @strongify(self);
        if (index == 1) {
            [self saveImgButtonClick];
        }
    }];
    [sheetView showInView:nil];
}


/// 保存图片到本地
- (void)saveImgButtonClick
{
    NSInteger index = self.pageControl.currentPage;
    //安全判断
    if (index >= self.imageUrlArray.count) {
        return;
    }
    
    NSString * imgUrl = self.imageUrlArray[index];
    //相册
    PHAuthorizationStatus photoAuthorStatus = [PHPhotoLibrary authorizationStatus];
    //如果未授权过
    if (photoAuthorStatus == PHAuthorizationStatusNotDetermined) {
        //请求首次权限
        [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
            //更新到主线程
            dispatch_async(dispatch_get_main_queue(), ^{
                [self checkPhotoAuthStatus:status imgUrl:imgUrl];
            });
        }];
    }
    else
    {
        [self checkPhotoAuthStatus:photoAuthorStatus imgUrl:imgUrl];
    }
}

/// 检查相册权限，并进行后续逻辑处理
/// @param status 相册权限
/// @param imgUrl 图片链接
- (void)checkPhotoAuthStatus:(PHAuthorizationStatus)status imgUrl:(NSString *)imgUrl
{
    //这里已经过滤掉status = PHAuthorizationStatusNotDetermined的情况
    //用户已允许
    if (status == PHAuthorizationStatusAuthorized)
    {
        [QGHUDManager showHud:nil];
        @weakify(self);
        //下载图片
        [[SDWebImageManager sharedManager] loadImageWithURL:[NSURL URLWithString:imgUrl] options:0 progress:nil completed:^(UIImage * _Nullable image, NSData * _Nullable data, NSError * _Nullable error, SDImageCacheType cacheType, BOOL finished, NSURL * _Nullable imageURL) {
            [QGHUDManager hideHud];
            @strongify(self);
            if (image) {
                [self loadImageFinished:image];
            }
            else
            {
                [QGHUDManager showHud:@"图片下载失败"];
            }
            
        }];
    }
    //用户未允许
    else
    {
        QGAlertView * alert = [[QGAlertView alloc] initWithTitle:nil message:@"您未开启照片权限，请前往设置-隐私-照片中打开访问照片权限" cancelButtonTitle:nil sureButtonTitle:@"我知道了" clickBlock:nil];
        [alert showInView:nil];
    }
}

//写入图片到相册
- (void)loadImageFinished:(UIImage *)image
{
    [[PHPhotoLibrary sharedPhotoLibrary] performChanges:^{
         [PHAssetChangeRequest creationRequestForAssetFromImage:image];
     } completionHandler:^(BOOL success, NSError * _Nullable error) {
         //保存成功后，弹窗并跳转到朋友圈
         if (success) {
             //更新到主线程
             dispatch_async(dispatch_get_main_queue(), ^{
                 [QGHUDManager showHud:@"保存成功"];
             });
         }
    }];
}

@end
