//
//  MagnifyImageView.h
//  Dreamore
//
//  Created by 陈晓宁 on 15/9/16.
//  Copyright (c) 2015年 zhangbo. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef void(^ScrollFinishedBlock)(NSInteger index);

@interface MagnifyImageView : UIView


@property (strong, nonatomic)ScrollFinishedBlock scrollBlock;

/**
 *  处理点击图片放大
 *
 *  @param defaultImageview 被点击的图片作为默认展示
 *  @param index            默认图片的位置
 *  @param images           所有图片（图片url和尺寸）
 *
 *  @return self
 */
- (instancetype)initMagnifyImageViewWithDefault:(UIView*)defaultImageview index:(NSInteger)index allImages:(NSArray *)images;
/**
 *  处理点击图片放大
 *
 *  @param defaultImageview 被点击的图片作为默认展示
 *  @param index            默认图片的位置
 *  @param images           所有图片（图片url和尺寸）
 *  @param isNeed           是否需要pageControl
 *  @return self
 */
- (instancetype)initMagnifyImageViewWithDefault:(UIView*)defaultImageview index:(NSInteger)index allImages:(NSArray *)images isNeedPageControl:(BOOL)isNeed;

- (void)addKeyWindow;

@end
