//
//  QGLoadingView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/13.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

///圆弧线的宽度
#define ArcCenterLineWidth 2.f
///logo距离父视图的间隔
#define LogoDistanceSuper (ArcCenterLineWidth + 4)
///圆弧最小的半径
#define ArcCenterMinRadius 2.f
///高光宽度
#define HighlightGradientLayerWidth 5.f

#define ChangeAngle @"changeAngle"

#import "QGLoadingView.h"

#import "UIColor+QGColor.h"
#import "UIView+Creat.h"
@interface QGLoadingView ()

@property (nonatomic, strong) UIImageView * logoImageView;

@end


@implementation QGLoadingView

- (void)dealloc
{
    NSLog(@"______%@",self);
}

- (CGSize)intrinsicContentSize
{
    return CGSizeMake(38, 38);
}

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initNormalUI];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self = [super initWithCoder:aDecoder]) {
        [self initNormalUI];
    }
    return self;
}

- (void)initNormalUI
{
    self.backgroundColor = [UIColor clearColor];
    [self initGrayBackgroundLayer];
    CGFloat animationDuration = 0.8;
    [self initCircleLayerWithAnimationDuration:animationDuration];
    [self initLogoImageViewWithAnimationDuration:animationDuration];
    [self initHighlightLayerWithAnimationDuration:animationDuration * 1.5/2];
    
}

///初始化灰色背景图层
- (void)initGrayBackgroundLayer
{
    //贝塞尔曲线画圆弧
    UIBezierPath *circlePath = [UIBezierPath bezierPathWithArcCenter:CGPointMake(self.intrinsicContentSize.width/2, self.intrinsicContentSize.height/2) radius:(self.intrinsicContentSize.width - ArcCenterLineWidth * 2)/2 startAngle:0 endAngle:2 * M_PI clockwise:YES];
    
    CAShapeLayer *bgLayer = [CAShapeLayer layer];
    bgLayer.frame = CGRectMake(0, 0, self.intrinsicContentSize.width, self.intrinsicContentSize.height);
    bgLayer.fillColor = [UIColor clearColor].CGColor;//填充色 -  透明色
    bgLayer.lineWidth = ArcCenterLineWidth;
    bgLayer.strokeColor = [UIColor moduleSeparatorColorF7F7].CGColor;//线条颜色
    bgLayer.strokeStart = 0;
    bgLayer.strokeEnd = 1;
    bgLayer.lineCap = kCALineCapRound;
    bgLayer.path = circlePath.CGPath;
    [self.layer addSublayer:bgLayer];
}

///初始化圆弧图层
- (void)initCircleLayerWithAnimationDuration:(CGFloat)animationDuration
{
    QGArcCircleLayer * layer = [[QGArcCircleLayer alloc] init];
    layer.frame = CGRectMake(0, 0, self.intrinsicContentSize.width,self.intrinsicContentSize.height);
    [self.layer addSublayer:layer];
    
    //圆弧放大缩小动画
    CAKeyframeAnimation * changeAnimation  = [CAKeyframeAnimation animationWithKeyPath:ChangeAngle];
    changeAnimation.values = @[@(0.01),@(0.01),@(M_PI/2),@(0.01),@(M_PI/2),@(0.01),@(0.01)];
    changeAnimation.keyTimes = @[@(0),@(0.12),@(0.35),@(0.5),@(0.65),@(0.88),@(1)];
    changeAnimation.duration = animationDuration * 1.5;
    changeAnimation.repeatCount = INT_MAX;
    
    //旋转动画
    CAKeyframeAnimation * rotationKeyAnimation = [CAKeyframeAnimation animationWithKeyPath:@"transform.rotation"];
    rotationKeyAnimation.duration = animationDuration;
    rotationKeyAnimation.values = @[@(0),@(M_PI * 0.5),@(M_PI),@(M_PI * 1.5),@(M_PI * 2)];
    rotationKeyAnimation.keyTimes = @[@(0),@(0.18),@(0.54),@(0.77),@(1)];
    rotationKeyAnimation.repeatCount = INT_MAX;
    
    //缩放动画
    CAKeyframeAnimation * scaleAnimation  = [CAKeyframeAnimation animationWithKeyPath:@"transform.scale"];
    scaleAnimation.values = @[@(0.05),@(1),@(1),@(1),@(1),@(1),@(0.05)];
    scaleAnimation.keyTimes = @[@(0),@(0.12),@(0.35),@(0.5),@(0.65),@(0.88),@(1)];
    scaleAnimation.duration = animationDuration * 1.5;
    scaleAnimation.repeatCount = INT_MAX;
    
    CAAnimationGroup * animationGroup = [CAAnimationGroup animation];
    animationGroup.animations = @[changeAnimation,rotationKeyAnimation,scaleAnimation];
    animationGroup.repeatCount = INT_MAX;
    animationGroup.duration = animationDuration * 1.5;
    animationGroup.removedOnCompletion = NO;
    [layer addAnimation:animationGroup forKey:nil];
}

- (void)initHighlightLayerWithAnimationDuration:(CGFloat)duration
{
    UIBezierPath *circlePath = [UIBezierPath bezierPathWithArcCenter:CGPointMake(self.intrinsicContentSize.width/2, self.intrinsicContentSize.height/2) radius:(self.intrinsicContentSize.width - LogoDistanceSuper * 2)/2 startAngle:0 endAngle:2 * M_PI clockwise:YES];
    
    //亮光的背景Layer 到时候就在这个页面添加Mask
    CALayer *lightBackLayer = [[CALayer alloc] init];
    lightBackLayer.backgroundColor = [UIColor clearColor].CGColor;
    lightBackLayer.frame = CGRectMake(0, 0, self.intrinsicContentSize.width, self.intrinsicContentSize.height);
    [self.layer addSublayer:lightBackLayer];
    
    //添加遮罩 避免高光漏出来
    CAShapeLayer *maskLayer = [CAShapeLayer layer];
    maskLayer.path = circlePath.CGPath;
    lightBackLayer.mask = maskLayer;
    
    //高光渐变色
    CAGradientLayer *grandLayer = [[CAGradientLayer alloc] init];
    grandLayer.colors = @[(__bridge id)[[UIColor whiteColor] colorWithAlphaComponent:0.0].CGColor,(__bridge id)[[UIColor whiteColor] colorWithAlphaComponent:0.3].CGColor,(__bridge id)[[UIColor whiteColor] colorWithAlphaComponent:0.0].CGColor];
    grandLayer.frame = CGRectMake(-HighlightGradientLayerWidth, 0, HighlightGradientLayerWidth, self.intrinsicContentSize.height);
    grandLayer.startPoint = CGPointMake(0, 0.5);//渲染的开始
    grandLayer.endPoint = CGPointMake(1, 0.5);//渲染的结束
    grandLayer.transform = CATransform3DMakeRotation(M_PI / 6.0, 0.0, 0.0, 1);
    [lightBackLayer addSublayer:grandLayer];
    
    //动画
    CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath:@"position"];
    animation.fromValue = [NSValue valueWithCGPoint:CGPointMake(0, HighlightGradientLayerWidth)];
    animation.toValue = [NSValue valueWithCGPoint:CGPointMake(self.intrinsicContentSize.width, self.intrinsicContentSize.height - HighlightGradientLayerWidth)];
    animation.repeatCount = INT_MAX;
    animation.duration = duration;
    animation.removedOnCompletion = NO;
    animation.fillMode = kCAFillModeForwards;
    [grandLayer addAnimation:animation forKey:nil];
    
}

///初始化logo
- (void)initLogoImageViewWithAnimationDuration:(CGFloat)duration
{
    self.logoImageView = [UIView creatImageViewWithSuperView:self imageName:@"loading_logo"];
    self.logoImageView.frame = CGRectMake(LogoDistanceSuper, LogoDistanceSuper, self.intrinsicContentSize.width - 2 * LogoDistanceSuper, self.intrinsicContentSize.height - 2 * LogoDistanceSuper);
    self.logoImageView.layer.cornerRadius = CGRectGetHeight(self.logoImageView.frame)/2.0;
    self.logoImageView.clipsToBounds = YES;
    self.logoImageView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    
    CAKeyframeAnimation * scaleAnimation  = [CAKeyframeAnimation animationWithKeyPath:@"transform.scale"];
    scaleAnimation.values = @[@(0.05),@(1),@(1),@(1),@(1),@(1),@(0.05)];
    scaleAnimation.keyTimes = @[@(0),@(0.12),@(0.35),@(0.5),@(0.65),@(0.88),@(1)];
    scaleAnimation.duration = duration * 1.5;
    scaleAnimation.repeatCount = INT_MAX;
    scaleAnimation.removedOnCompletion = NO;
    [self.logoImageView.layer addAnimation:scaleAnimation forKey:nil];
}



@end


@implementation QGArcCircleLayer


- (instancetype)initWithLayer:(id)layer
{
    if (self = [super initWithLayer:layer]) {
        if ([layer isKindOfClass:[QGArcCircleLayer class]]) {
            self.changeAngle = [(QGArcCircleLayer *)layer changeAngle];
        }
    }
    return self;
}


+ (BOOL)needsDisplayForKey:(NSString *)key
{
    if ([key isEqualToString:ChangeAngle]) {
        return YES;
    }
    return [super needsDisplayForKey:key];
}

- (void)drawInContext:(CGContextRef)ctx
{
    // 设置线的宽度
    CGContextSetLineWidth(ctx, ArcCenterLineWidth);
    //kCGLineCapRound 端点为圆角
    CGContextSetLineCap(ctx, kCGLineCapRound);
    ////填充色 -  透明色
    CGContextSetFillColorWithColor(ctx, [UIColor clearColor].CGColor);
    //线条颜色
    CGContextSetStrokeColorWithColor(ctx, [UIColor colorWithHexString:@"FF5A4B"].CGColor);
    
    CGFloat originX = CGRectGetWidth(self.frame)/2;
    CGFloat originY = CGRectGetHeight(self.frame)/2;
    CGFloat minWidth = MIN(originX, originY);
    
    CGFloat radius = minWidth - ArcCenterLineWidth;
    //M_PI * 0（右边的点）、M_PI * 1.5（上边的点）、M_PI * 1（左边的点）、M_PI * 0.5（下面的点）
    CGFloat topPointAngle = M_PI * 1.5;
    CGFloat bottomPointAngle = M_PI * 0.5;
    // 逆时针画一个圆弧
    CGContextAddArc(ctx, originX, originY, radius, topPointAngle + self.changeAngle/2.0, topPointAngle - self.changeAngle/2.0, 1);
    CGContextStrokePath(ctx);
    CGContextAddArc(ctx, originX, originY, radius, bottomPointAngle + self.changeAngle/2.0, bottomPointAngle - self.changeAngle/2.0, 1);
    CGContextStrokePath(ctx);
}




@end
