//
//  UIViewController+ChooseContactPhone.m
//  CreditWallet
//
//  Created by 张博 on 2018/6/20.
//  Copyright © 2018年 QuantGroup. All rights reserved.
//

#import "UIViewController+ChooseContactPhone.h"
#import <objc/runtime.h>
#import "QGHUDManager.h"
@implementation UIViewController (ChooseContactPhone) 

#pragma mark - Setter
- (void)setChooseSuccessBlock:(ChooseContactInfoSuccess)chooseSuccessBlock
{
    objc_setAssociatedObject(self, @selector(chooseSuccessBlock), chooseSuccessBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
}

- (void)setAddressBookPermissManager:(AccessPermissionsManager *)addressBookPermissManager
{
    objc_setAssociatedObject(self, @selector(addressBookPermissManager), addressBookPermissManager, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}

#pragma mark - Getter
- (ChooseContactInfoSuccess)chooseSuccessBlock
{
    return objc_getAssociatedObject(self, @selector(chooseSuccessBlock));
}

- (AccessPermissionsManager *)addressBookPermissManager
{
    return objc_getAssociatedObject(self, @selector(addressBookPermissManager));
}


///选择手机号码
- (void)chooseContactPhoneInfo:(ChooseContactInfoSuccess)successBlock {
    if (!self.addressBookPermissManager) {
        self.addressBookPermissManager = [[AccessPermissionsManager alloc]init];
    }
    //检测通讯录权限
    BOOL checkResult = [self.addressBookPermissManager checkAddressBook];
    
    if (checkResult) {
        ABPeoplePickerNavigationController *picker = [[ABPeoplePickerNavigationController alloc] init];
        picker.peoplePickerDelegate = self;
        picker.predicateForSelectionOfPerson = [NSPredicate predicateWithValue:NO];
        [self presentViewController:picker animated:YES completion:nil];
    }
    self.chooseSuccessBlock = successBlock;
}

#pragma mark - ABPeoplePickerNavigationControllerDelegate
//这个方法在用户取消选择时调用
- (void)peoplePickerNavigationControllerDidCancel:(ABPeoplePickerNavigationController *)peoplePicker {
    [self dismissViewControllerAnimated:YES
                             completion:^{
                             }];
}

//这个方法在用户选择一个联系人后调用
- (void)peoplePickerNavigationController:(ABPeoplePickerNavigationController *)peoplePicker didSelectPerson:(ABRecordRef)person {
    ABPersonViewController *personViewController = [[ABPersonViewController alloc] init];
    personViewController.displayedPerson = person;
    [peoplePicker pushViewController:personViewController animated:YES];
    
}

- (void)peoplePickerNavigationController:(ABPeoplePickerNavigationController *)peoplePicker didSelectPerson:(ABRecordRef)person property:(ABPropertyID)property identifier:(ABMultiValueIdentifier)identifier
{
    [self displayPerson:person identifier:identifier];
    [self dismissViewControllerAnimated:YES completion:nil];
}

//获得选中person的信息
- (void)displayPerson:(ABRecordRef)person identifier:(ABMultiValueIdentifier)identifier{
    NSString *firstName = (__bridge_transfer NSString *) ABRecordCopyValue(person, kABPersonFirstNameProperty);
    NSString *middleName = (__bridge_transfer NSString *) ABRecordCopyValue(person, kABPersonMiddleNameProperty);
    NSString *lastname = (__bridge_transfer NSString *) ABRecordCopyValue(person, kABPersonLastNameProperty);
    NSMutableString *nameStr = [NSMutableString string];
    if (lastname != nil) {
        [nameStr appendString:lastname];
    }
    if (middleName != nil) {
        [nameStr appendString:middleName];
    }
    if (firstName != nil) {
        [nameStr appendString:firstName];
    }
    
    NSString *phone = nil;
    ABMultiValueRef phoneNumbers = ABRecordCopyValue(person, kABPersonPhoneProperty);
    long index = ABMultiValueGetIndexForIdentifier(phoneNumbers,identifier);
    if (ABMultiValueGetCount(phoneNumbers) > 0) {
        phone = (__bridge_transfer NSString *) ABMultiValueCopyValueAtIndex(phoneNumbers, index);
    } else {
        phone = @"[None]";
    }
    
    //可以把-、+86、空格这些过滤掉
    NSString *phoneStr = [phone stringByReplacingOccurrencesOfString:@"-" withString:@""];
    phoneStr = [phoneStr stringByReplacingOccurrencesOfString:@"+86" withString:@""];
    phoneStr = [[phoneStr componentsSeparatedByCharactersInSet:[NSCharacterSet whitespaceCharacterSet]] componentsJoinedByString:@""];
    if (phoneStr.length != 11) {
        [QGHUDManager showHud:@"请选择11位手机号码"];
        return;
    }
    
    if (self.chooseSuccessBlock) {
        self.chooseSuccessBlock(phoneStr, nameStr);
    }
    
}


@end
