//
//  UIView+LayoutSubviewsCallback.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/16.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

///LayoutSubviews回调
typedef void(^UIViewLayoutSubviewsCallback)(UIView * view);


/**
 此类一般用于添加layer的时候，如果View使用了autolayout约束，layer无法获取到坐标
 */
@interface UIView (LayoutSubviewsCallback)

/**
 LayoutSubviews回调
 */
@property (nonatomic, copy) UIViewLayoutSubviewsCallback layoutSubviewsCallback;
@end

NS_ASSUME_NONNULL_END
