//
//  UISearchBar+SetBG.m
//  CreditWallet
//
//  Created by 逍遥子 on 16/8/17.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "UISearchBar+SetBG.h"
#import "QGAppMacro.h"
@implementation UISearchBar (SetBG)
/**
 不带放大镜的SearchBar 设置背景颜色

 @param backgroundColor 背景颜色
 */
- (void)setSearchTextFieldBackgroundColor:(UIColor *)backgroundColor
{
    UITextField *searchTextField = nil;
    if (iOS7) {
        // 经测试, 需要设置barTintColor后, 才能拿到UISearchBarTextField对象
        self.barTintColor = [UIColor whiteColor];
        searchTextField = [[[self.subviews firstObject] subviews] lastObject];
    } else { // iOS6以下版本searchBar内部子视图的结构不一样
        for (UITextField *subView in self.subviews) {
            if ([subView isKindOfClass:NSClassFromString(@"UISearchBarTextField")]) {
                searchTextField = subView;
            }
        }
    }
    searchTextField.backgroundColor = backgroundColor;
    UIView *leftView =[[UIView alloc]initWithFrame:CGRectMake(0, 0, 60, 0.01)];
    leftView.backgroundColor=[UIColor clearColor];
    searchTextField.leftViewMode=UITextFieldViewModeAlways;
    searchTextField.leftView=leftView;
}


/**
 带有放大镜，取消按钮字体颜色

 @param backgroundColor 背景颜色
 @param alpha 输入框透明度
 @param titleColor 取消按钮字体颜色
 */
- (void)setSearchTextFieldBackgroundColor:(UIColor *)backgroundColor alpha:(CGFloat)alpha  cancelBtnTitleColor:(UIColor *)titleColor
{
    UITextField *searchTextField = nil;
    UIButton *canBtn = nil;
    UIView *backgroundView = nil;
    if (iOS7) {
        // 经测试, 需要设置barTintColor后, 才能拿到UISearchBarTextField对象
        self.barTintColor = [UIColor whiteColor];
        canBtn = [self valueForKey:@"cancelButton"];
        searchTextField = [self valueForKey:@"_searchField"];
    } else { // iOS6以下版本searchBar内部子视图的结构不一样
        for (UIView *subView in self.subviews) {
            if ([subView isKindOfClass:NSClassFromString(@"UISearchBarTextField")]) {
                searchTextField = (UITextField *)subView;
                
               
            }
            if ([subView isKindOfClass:[UIButton class]]) {
                canBtn = (UIButton *)subView;
            }
            if ([subView isKindOfClass:NSClassFromString(@"UISearchBarBackground")]) {
                 backgroundView = (UIView *)subView;
            }
        }
    }
    
    searchTextField.backgroundColor = backgroundColor;
    searchTextField.alpha = alpha;
//    [searchTextField setTintColor:[UIColor mainBlueColor]];
    searchTextField.enablesReturnKeyAutomatically = NO;
    if (titleColor) {
        [canBtn setTitleColor:titleColor forState:UIControlStateNormal];
        [canBtn setTitle:@"取消" forState:UIControlStateNormal];
        canBtn.titleLabel.font = [UIFont systemFontOfSize:14.0f];
    }
   [backgroundView removeFromSuperview];
    
}


/**
 设置Placeholder的对齐方式

 @param hasCenterPlaceholder 是否居中 YES居中 NO居左
 */
- (void)setHasCenterPlaceholder:(BOOL)hasCenterPlaceholder
{
    SEL centerSelector = NSSelectorFromString([NSString stringWithFormat:@"%@%@", @"setCenter", @"Placeholder:"]);
    if ([self respondsToSelector:centerSelector])
    {
        NSMethodSignature *signature = [[UISearchBar class] instanceMethodSignatureForSelector:centerSelector];
        NSInvocation *invocation = [NSInvocation invocationWithMethodSignature:signature];
        [invocation setTarget:self];
        [invocation setSelector:centerSelector];
        [invocation setArgument:&hasCenterPlaceholder atIndex:2];
        [invocation invoke];
    }
    
}
@end
