//
//  UIImageView+QGWebCache.m
//  CreditWallet
//
//  Created by 张博 on 16/8/29.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "NSString+CreditWallet.h"
#import "UIImage+CreditWallet.h"
#import "UIImageView+QGWebCache.h"
#import "UIImageView+WebCache.h"
#import "UIView+Extend.h"
#import "DeviceAdaptation.h"
@implementation UIImageView (QGWebCache)


/// 商城相关默认图 （完全充满）
/// @param urlStr 图片链接
- (void)setMallImageByNomalPlaceholderWithURLString:(NSString *)urlStr
{
    UIViewContentMode contentMode = self.contentMode;
    self.contentMode = UIViewContentModeScaleAspectFill;
    self.clipsToBounds = YES;
    UIImage *placeholderImage = [UIImage imageNamed:@"mall_common_placeholder"];

    NSURL *url = [NSURL URLWithString:urlStr];
    if (!url) {
        urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
        url = [NSURL URLWithString:urlStr];
    }
    __weak typeof(self) weakSelf = self;
    [self sd_setImageWithURL:url placeholderImage:placeholderImage completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
       if (image) {
           weakSelf.contentMode = contentMode;
       }
    }];
}


///根据URL设置图片，有默认的替代图
- (void)setImageByNomalPlaceholderWithURLString:(NSString *)urlStr {
    UIViewContentMode contentMode = self.contentMode;
    self.contentMode = UIViewContentModeScaleAspectFit;
    self.clipsToBounds = YES;
    UIImage *placeholderImage = [UIImage imageNamed:@"ad_banner_placeholder"];

    NSURL *url = [NSURL URLWithString:urlStr];
    if (!url) {
        urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
        url = [NSURL URLWithString:urlStr];
    }

    __weak typeof(self) weakSelf = self;
    [self sd_setImageWithURL:url
            placeholderImage:placeholderImage
                   completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {

                       if (image) {
                           weakSelf.contentMode = contentMode;
                       }
                   }];
}

/**
 根据URL设置图片 并需要提供默认图片

 @param placeholder 默认图片名字
 @param urlStr 下载地址
 */
- (void)setImageWithPlaceholder:(NSString *)placeholder URLString:(NSString *)urlStr {
    UIViewContentMode contentMode = self.contentMode;
    self.contentMode = UIViewContentModeScaleAspectFit;
    self.clipsToBounds = YES;

    placeholder = placeholder.length > 0 ? placeholder : @"PlaceholderBanner";

    UIImage *placeholderImage = [UIImage imageNamed:placeholder];

    NSURL *url = [NSURL URLWithString:urlStr];
    if (!url) {
        urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
        url = [NSURL URLWithString:urlStr];
    }

    __weak typeof(self) weakSelf = self;
    [self sd_setImageWithURL:url
            placeholderImage:placeholderImage
                   completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {

                       if (image) {
                           weakSelf.contentMode = contentMode;
                       }
                   }];
}

/**
 根据URL设置图片 并需要提供默认图片
 
 @param placeholder 默认图片名字
 @param urlStr WebP下载地址
 */
- (void)setWebPImageWithPlaceholder:(NSString *)placeholder URLString:(NSString *)urlStr {
    UIViewContentMode contentMode = self.contentMode;
    self.contentMode = UIViewContentModeScaleAspectFit;
    self.clipsToBounds = YES;

    placeholder = placeholder.length > 0 ? placeholder : @"PlaceholderBanner";

    UIImage *placeholderImage = [UIImage imageNamed:placeholder];

    NSURL *url = [NSURL URLWithString:urlStr];
    if (!url) {
        urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    }
    if (urlStr) {
        url = [NSURL URLWithString:[NSString addWebPFormatFromUrlStr:urlStr]];
    }
    __weak typeof(self) weakSelf = self;
    [self sd_setImageWithURL:url
            placeholderImage:placeholderImage
                   completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {

                       if (image) {
                           weakSelf.contentMode = contentMode;
                       }
                   }];
}

///设置contentMode
- (void)setAspectFillMode {
    self.contentMode = UIViewContentModeScaleAspectFill;
    self.clipsToBounds = YES;
}

- (void)zb_setImageWithURL:(NSURL *)url placeholderImage:(UIImage *)placeholder activityIndicatorVisible:(BOOL)isVisible complete:(SDExternalCompletionBlock)complete {
    __weak typeof(self) weakSelf = self;

    UIActivityIndicatorView *activityView = nil;
    if (isVisible) {
        if (![self viewWithTag:10000]) {
            activityView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhite];
            [self addSubview:activityView];
            activityView.tag = 10000;
            [activityView startAnimating];
            activityView.center = CGPointMake(self.width / 2, self.height / 2);
        }
    }

    [self sd_setImageWithURL:url
            placeholderImage:placeholder
                   completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {

                       if (complete) {
                           complete(image, error, cacheType, imageURL);
                       }

                       dispatch_async(dispatch_get_main_queue(), ^{
                           UIActivityIndicatorView *myActivityView = (UIActivityIndicatorView *) [weakSelf viewWithTag:10000];
                           [myActivityView removeFromSuperview];
                       });

                   }];
}

/**
 根据URL设置图片 并需要提供默认图片
 在scale>2的屏幕 重新绘制
 @param placeholder 默认图片名字
 @param urlStr 下载地址
 */
- (void)qg_setImageWithPlaceholder:(NSString *)placeholder URLString:(NSString *)urlStr {

    UIImage *placeholderImage = [UIImage imageNamed:[NSString getCheckString:placeholder]];

    NSURL *url = [NSURL URLWithString:urlStr];
    if (!url) {
        urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
        url = [NSURL URLWithString:urlStr];
    }
    __weak typeof(self) weakSelf = self;
    [self sd_setImageWithURL:url
            placeholderImage:placeholderImage
                   completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, NSURL *imageURL) {
                       __strong __typeof(weakSelf) strongSelf = weakSelf;
                       if (image) {
                           CGSize imageSize = CGSizeMake(image.size.width * [[UIScreen mainScreen] scale]/2.0, image.size.height * [[UIScreen mainScreen] scale]/2.0);
                           strongSelf.image = [image imageByScalingAndCroppingForTargetSize:imageSize];
                       }
                   }];
}

@end
