//
//  UIImageView+QGWebCache.h
//  CreditWallet
//
//  Created by 张博 on 16/8/29.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "SDWebImageManager.h"
#import <UIKit/UIKit.h>
@interface UIImageView (QGWebCache)

/// 商城相关默认图 （完全充满）
/// @param urlStr 图片链接
- (void)setMallImageByNomalPlaceholderWithURLString:(NSString *)urlStr;

///根据URL设置图片，有默认的替代图
- (void)setImageByNomalPlaceholderWithURLString:(NSString *)urlStr;

/**
 根据URL设置图片 并需要提供默认图片
 
 @param placeholder 默认图片名字
 @param urlStr 下载地址
 */
- (void)setImageWithPlaceholder:(NSString *)placeholder URLString:(NSString *)urlStr;

/**
 根据URL设置图片 并需要提供默认图片
 
 @param placeholder 默认图片名字
 @param urlStr WebP下载地址
 */
- (void)setWebPImageWithPlaceholder:(NSString *)placeholder URLString:(NSString *)urlStr;

///设置contentMode
- (void)setAspectFillMode;

- (void)zb_setImageWithURL:(NSURL *)url placeholderImage:(UIImage *)placeholder activityIndicatorVisible:(BOOL)isVisible complete:(SDExternalCompletionBlock)complete;

/**
 根据URL设置图片 并需要提供默认图片
 在scale>2的屏幕 重新绘制
 @param placeholder 默认图片名字
 @param urlStr 下载地址
 */
- (void)qg_setImageWithPlaceholder:(NSString *)placeholder URLString:(NSString *)urlStr;
@end
