//
//  UIImage+CreditWallet.m
//  CreditWallet
//
//  Created by 逍遥子 on 2016/11/17.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "UIImage+CreditWallet.h"

@implementation UIImage (CreditWallet)

/**
 *  把图片等比例缩放到指定尺寸  不失真
 
 *  @param targetSize 目标尺寸
 *  @return 获得图片
 */
- (UIImage * )imageByScalingAndCroppingForTargetSize:(CGSize)targetSize
{
    //资源图片
    UIImage *sourceImage = self;
    //目标图片
    UIImage *newImage = nil;
    //图片原尺寸
    CGSize imageSize = sourceImage.size;
    //图片原宽度
    CGFloat width = imageSize.width;
    //图片原高度
    CGFloat height = imageSize.height;
    //目标宽度
    CGFloat targetWidth = targetSize.width;
    //目标高度
    CGFloat targetHeight = targetSize.height;
    //缩放比例
    CGFloat scaleFactor = 0.0;
    //默认缩放宽度
    CGFloat scaledWidth = targetWidth;
    //默认缩放高度
    CGFloat scaledHeight = targetHeight;
    
    CGPoint thumbnailPoint = CGPointMake(0.0,0.0);
    
    if (CGSizeEqualToSize(imageSize, targetSize) == NO)
        
    {
        //按照尺寸缩放算出目标尺寸  按照最大最大尺寸等比缩放
        CGFloat widthFactor = targetWidth / width;
        
        CGFloat heightFactor = targetHeight / height;
        
        if (widthFactor > heightFactor)
            
            scaleFactor = widthFactor; // scale to fit height
        
        else
            
            scaleFactor = heightFactor; // scale to fit width
        
        scaledWidth= width * scaleFactor;
        
        scaledHeight = height * scaleFactor;
        
        //计算左侧的点
        // center the image
        
        if (widthFactor > heightFactor)
            
        {
            
            thumbnailPoint.y = (targetHeight - scaledHeight) * 0.5;
            
        }
        
        else if (widthFactor < heightFactor)
            
        {
            
            thumbnailPoint.x = (targetWidth - scaledWidth) * 0.5;
            
        }
        
    }
    
    //获取画板开始绘制
//    UIGraphicsBeginImageContext(targetSize); // this will crop
    UIGraphicsBeginImageContextWithOptions(targetSize, NO, [UIScreen mainScreen].scale);
    
    CGRect thumbnailRect = CGRectZero;
    
    thumbnailRect.origin = thumbnailPoint;
    
    thumbnailRect.size.width= scaledWidth;
    
    thumbnailRect.size.height = scaledHeight;
    
    [sourceImage drawInRect:thumbnailRect];
    
    newImage = UIGraphicsGetImageFromCurrentImageContext();
    
    if(newImage == nil)
        
        NSLog(@"could not scale image");
    
    //pop the context to get back to the default
    
    UIGraphicsEndImageContext();
    
    return newImage;
    
}

/**
 *  把图片等比例缩放到不低于指定尺寸
 *
 *  @param minSize 目标最低尺寸
 *
 *  @return 获得图片
 */
- (UIImage *)imageByScalingAndCroppingForMinSize:(CGSize)minSize
{
    //资源图片
    UIImage *sourceImage = self;
    //目标图片
    UIImage *newImage = nil;
    //图片原尺寸
    CGSize imageSize = sourceImage.size;
    //图片原宽高
    CGFloat width = imageSize.width;
    CGFloat height = imageSize.height;
    //最小宽高
    CGFloat minWidth = minSize.width;
    CGFloat minHeight = minSize.height;
    
    //目标尺寸
    CGFloat targetWidth = 0;
    CGFloat targetHeight = 0;
    
    //按照尺寸缩放算出目标尺寸  按照最大最大尺寸等比缩放
    CGFloat widthFactor = minWidth / width;
    CGFloat heightFactor = minHeight / height;
    
    //目标宽高不能低于指定宽高，则谁大，就用谁的比例
    if (heightFactor > widthFactor) {
        targetWidth = heightFactor * width;
        targetHeight = heightFactor * height;
    }
    else
    {
        targetWidth = widthFactor * width;
        targetHeight = widthFactor * height;
    }
    CGSize targetSize = CGSizeMake(targetWidth, targetHeight);
    UIGraphicsBeginImageContextWithOptions(targetSize, NO, 1.0);
    [sourceImage drawInRect:CGRectMake(0, 0, targetWidth, targetHeight)];
    newImage = UIGraphicsGetImageFromCurrentImageContext();
    if(newImage == nil)
        NSLog(@"could not scale image");
    //pop the context to get back to the default
    UIGraphicsEndImageContext();
    return newImage;

}

/**
 图片转成Base64字符串,并压缩到指定内存大小
 
 @param maxLength 目标大小
 @param minSize 最小尺寸
 @return 字符串
 */
-(NSString *)imageToBase64StrMaxLength:(NSInteger)maxLength minSize:(CGSize)minSize
{
    UIImage * sourceImage = [self imageByScalingAndCroppingForMinSize:minSize];
    NSData * sourceData = [sourceImage compressQualityWithMaxLength:maxLength];
    //    UIImage * image = [UIImage imageWithData:sourceData];
    //    NSLog(@"转Base64压缩后图片大小：%luk imageSize = %@",(unsigned long)sourceData.length/1024,NSStringFromCGSize(image.size));
    NSString *encodedImageStr = [sourceData base64EncodedStringWithOptions:NSDataBase64Encoding64CharacterLineLength];
    return encodedImageStr;
    
}

/**
 将图片压缩到指定的大小，单位是B
 
 @param maxLength 目标大小，单位是B
 @return 返回压缩后的大小
 */
- (NSData *)compressQualityWithMaxLength:(NSInteger)maxLength {
    CGFloat compression = 1;
    NSData *data = UIImageJPEGRepresentation(self, compression);
    if (data.length < maxLength) return data;
    CGFloat max = 1;
    CGFloat min = 0;
    for (int i = 0; i < 6; ++i) {
        compression = (max + min) / 2;
        data = UIImageJPEGRepresentation(self, compression);
        if (data.length < maxLength * 0.9) {
            min = compression;
        } else if (data.length > maxLength) {
            max = compression;
        } else {
            break;
        }
    }
    return data;
}



//颜色转图片
+(UIImage *)imageWithColor:(UIColor *)color size:(CGSize)size
{
    CGRect rect = CGRectMake(0, 0, size.width, size.height);
    UIGraphicsBeginImageContext(rect.size);
    CGContextRef context = UIGraphicsGetCurrentContext();
    CGContextSetFillColorWithColor(context, [color CGColor]);
    CGContextFillRect(context, rect);
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}

/**
 颜色转图片 带圆角
 
 @param color 颜色
 @param size 尺寸
 @param radius 圆角
 @return 目标图片
 */
+(UIImage *)imageWithColor:(UIColor *)color size:(CGSize)size cornerRadius:(CGFloat)radius
{
    CGRect rect = CGRectMake(0, 0, size.width, size.height);
    UIGraphicsBeginImageContextWithOptions(rect.size, NO, 0);
    CGContextRef context = UIGraphicsGetCurrentContext();
    CGContextAddEllipseInRect(context, rect);
    [color set];
    CGContextFillPath(context);
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}


/**
 截屏window

 @param view 提供上下文大小、透明开关
 @return 返回截屏图片
 */
+ (UIImage *)snapshotWithView:(UIView *)view
{
    @autoreleasepool
    {
        UIGraphicsBeginImageContextWithOptions(view.bounds.size, view.opaque, 0);
        [[UIApplication sharedApplication].keyWindow.layer renderInContext:UIGraphicsGetCurrentContext()];
        UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        return image;
    }
}




@end
